/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpExecuteInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpIOExceptionHandler;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpResponseInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ChainingHttpRequestInitializer
implements HttpRequestInitializer {
    private final List<HttpRequestInitializer> initializers;

    public ChainingHttpRequestInitializer(HttpRequestInitializer ... initializers) {
        this.initializers = ImmutableList.copyOf(initializers);
    }

    @Override
    public void initialize(HttpRequest request) throws IOException {
        ArrayList<HttpIOExceptionHandler> ioExceptionHandlers = new ArrayList<HttpIOExceptionHandler>(this.initializers.size());
        ArrayList<HttpUnsuccessfulResponseHandler> unsuccessfulResponseHandlers = new ArrayList<HttpUnsuccessfulResponseHandler>(this.initializers.size());
        ArrayList<HttpExecuteInterceptor> interceptors = new ArrayList<HttpExecuteInterceptor>(this.initializers.size());
        ArrayList<HttpResponseInterceptor> responseInterceptors = new ArrayList<HttpResponseInterceptor>(this.initializers.size());
        for (HttpRequestInitializer initializer : this.initializers) {
            initializer.initialize(request);
            if (request.getIOExceptionHandler() != null) {
                ioExceptionHandlers.add(request.getIOExceptionHandler());
                request.setIOExceptionHandler(null);
            }
            if (request.getUnsuccessfulResponseHandler() != null) {
                unsuccessfulResponseHandlers.add(request.getUnsuccessfulResponseHandler());
                request.setUnsuccessfulResponseHandler(null);
            }
            if (request.getInterceptor() != null) {
                interceptors.add(request.getInterceptor());
                request.setInterceptor(null);
            }
            if (request.getResponseInterceptor() == null) continue;
            responseInterceptors.add(request.getResponseInterceptor());
            request.setResponseInterceptor(null);
        }
        request.setIOExceptionHandler(this.makeIoExceptionHandler(ioExceptionHandlers));
        request.setUnsuccessfulResponseHandler(this.makeUnsuccessfulResponseHandler(unsuccessfulResponseHandlers));
        request.setInterceptor(this.makeInterceptor(interceptors));
        request.setResponseInterceptor(this.makeResponseInterceptor(responseInterceptors));
    }

    private HttpResponseInterceptor makeResponseInterceptor(Iterable<HttpResponseInterceptor> responseInterceptors) {
        return response -> {
            for (HttpResponseInterceptor interceptor : responseInterceptors) {
                interceptor.interceptResponse(response);
            }
        };
    }

    private HttpExecuteInterceptor makeInterceptor(Iterable<HttpExecuteInterceptor> interceptors) {
        return request -> {
            for (HttpExecuteInterceptor interceptor : interceptors) {
                interceptor.intercept(request);
            }
        };
    }

    private HttpUnsuccessfulResponseHandler makeUnsuccessfulResponseHandler(Iterable<HttpUnsuccessfulResponseHandler> unsuccessfulResponseHandlers) {
        return (request, response, supportsRetry) -> {
            for (HttpUnsuccessfulResponseHandler handler : unsuccessfulResponseHandlers) {
                if (!handler.handleResponse(request, response, supportsRetry)) continue;
                return true;
            }
            return false;
        };
    }

    private HttpIOExceptionHandler makeIoExceptionHandler(Iterable<HttpIOExceptionHandler> ioExceptionHandlers) {
        return (request, supportsRetry) -> {
            for (HttpIOExceptionHandler handler : ioExceptionHandlers) {
                if (!handler.handleIOException(request, supportsRetry)) continue;
                return true;
            }
            return false;
        };
    }
}

