/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ErrorTypeExtractor;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.StatusRuntimeException;
import javax.annotation.Nullable;

public class GrpcErrorTypeExtractor
implements ErrorTypeExtractor {
    public static final GrpcErrorTypeExtractor INSTANCE = new GrpcErrorTypeExtractor();
    private static final String BUCKET_ALREADY_EXISTS_MESSAGE = "FAILED_PRECONDITION: Your previous request to create the named bucket succeeded and you already own it.";

    private GrpcErrorTypeExtractor() {
    }

    @Override
    public ErrorTypeExtractor.ErrorType getErrorType(Exception error) {
        switch (Status.fromThrowable(error).getCode()) {
            case NOT_FOUND: {
                return ErrorTypeExtractor.ErrorType.NOT_FOUND;
            }
            case OUT_OF_RANGE: {
                return ErrorTypeExtractor.ErrorType.OUT_OF_RANGE;
            }
            case ALREADY_EXISTS: {
                return ErrorTypeExtractor.ErrorType.ALREADY_EXISTS;
            }
            case FAILED_PRECONDITION: {
                return ErrorTypeExtractor.ErrorType.FAILED_PRECONDITION;
            }
            case RESOURCE_EXHAUSTED: {
                return ErrorTypeExtractor.ErrorType.RESOURCE_EXHAUSTED;
            }
            case INTERNAL: {
                return ErrorTypeExtractor.ErrorType.INTERNAL;
            }
            case UNAVAILABLE: {
                return ErrorTypeExtractor.ErrorType.UNAVAILABLE;
            }
        }
        return ErrorTypeExtractor.ErrorType.UNKNOWN;
    }

    @Override
    public boolean bucketAlreadyExists(Exception e) {
        ErrorTypeExtractor.ErrorType errorType = this.getErrorType(e);
        if (errorType == ErrorTypeExtractor.ErrorType.ALREADY_EXISTS) {
            return true;
        }
        if (errorType == ErrorTypeExtractor.ErrorType.FAILED_PRECONDITION) {
            StatusRuntimeException statusRuntimeException = this.getStatusRuntimeException(e);
            return statusRuntimeException != null && BUCKET_ALREADY_EXISTS_MESSAGE.equals(statusRuntimeException.getMessage());
        }
        return false;
    }

    @Nullable
    private StatusRuntimeException getStatusRuntimeException(Exception e) {
        Throwable cause = e;
        int maxChainDepth = 1000;
        for (int currentExceptionDepth = 0; cause != null && currentExceptionDepth < maxChainDepth; cause = cause.getCause(), ++currentExceptionDepth) {
            if (!(cause instanceof StatusRuntimeException)) continue;
            return (StatusRuntimeException)cause;
        }
        return null;
    }
}

