/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util;

import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.AutoValue_RetryHttpInitializerOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Nullable;

@AutoValue
public abstract class RetryHttpInitializerOptions {
    public static final RetryHttpInitializerOptions DEFAULT = RetryHttpInitializerOptions.builder().build();

    public static Builder builder() {
        return new AutoValue_RetryHttpInitializerOptions.Builder().setConnectTimeout(Duration.ofSeconds(5L)).setDefaultUserAgent(null).setHttpHeaders(ImmutableMap.of()).setMaxRequestRetries(10).setReadTimeout(Duration.ofSeconds(5L));
    }

    public abstract Builder toBuilder();

    @Nullable
    public abstract String getDefaultUserAgent();

    public abstract ImmutableMap<String, String> getHttpHeaders();

    public abstract Duration getConnectTimeout();

    public abstract Duration getReadTimeout();

    public abstract int getMaxRequestRetries();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setDefaultUserAgent(String var1);

        public abstract Builder setHttpHeaders(Map<String, String> var1);

        public abstract Builder setConnectTimeout(Duration var1);

        public abstract Builder setReadTimeout(Duration var1);

        public abstract Builder setMaxRequestRetries(int var1);

        abstract RetryHttpInitializerOptions autoBuild();

        public RetryHttpInitializerOptions build() {
            RetryHttpInitializerOptions options = this.autoBuild();
            Preconditions.checkArgument(options.getHttpHeaders().keySet().stream().noneMatch("User-Agent"::equalsIgnoreCase), "The User-Agent header must be provided via the defaultUserAgent option");
            return options;
        }
    }
}

