/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Conversions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.HttpClientContext;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.HttpContentRange;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.JsonResumableSessionPutTask;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.JsonResumableSessionQueryTask;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.JsonResumableWrite;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ResumableOperationResult;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Retrying;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.RewindableContent;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.spi.v1.HttpRpcContext;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.spi.v1.HttpStorageRpc;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.trace.EndSpanOptions;
import java.util.concurrent.atomic.AtomicBoolean;
import org.checkerframework.checker.nullness.qual.Nullable;

final class JsonResumableSession {
    static final String SPAN_NAME_WRITE = String.format("Sent.%s.write", HttpStorageRpc.class.getName());
    static final EndSpanOptions END_SPAN_OPTIONS = EndSpanOptions.builder().setSampleToLocalSpanStore(true).build();
    private final HttpClientContext context;
    private final Retrying.RetryingDependencies deps;
    private final ResultRetryAlgorithm<?> alg;
    private final JsonResumableWrite resumableWrite;

    JsonResumableSession(HttpClientContext context, Retrying.RetryingDependencies deps, ResultRetryAlgorithm<?> alg, JsonResumableWrite resumableWrite) {
        this.context = context;
        this.deps = deps;
        this.alg = alg;
        this.resumableWrite = resumableWrite;
    }

    ResumableOperationResult<@Nullable StorageObject> query() {
        return new JsonResumableSessionQueryTask(this.context, this.resumableWrite).call();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResumableOperationResult<@Nullable StorageObject> put(RewindableContent content, HttpContentRange contentRange) {
        JsonResumableSessionPutTask task = new JsonResumableSessionPutTask(this.context, this.resumableWrite, content, contentRange);
        HttpRpcContext httpRpcContext = HttpRpcContext.getInstance();
        try {
            httpRpcContext.newInvocationId();
            AtomicBoolean dirty = new AtomicBoolean(false);
            ResumableOperationResult resumableOperationResult = (ResumableOperationResult)Retrying.run(this.deps, this.alg, () -> {
                if (dirty.getAndSet(true)) {
                    ResumableOperationResult<@Nullable StorageObject> query = this.query();
                    long persistedSize = query.getPersistedSize();
                    if (contentRange.endOffsetEquals(persistedSize) || query.getObject() != null) {
                        return query;
                    }
                    task.rewindTo(persistedSize);
                }
                return task.call();
            }, Conversions.Decoder.identity());
            return resumableOperationResult;
        }
        finally {
            httpRpcContext.clearInvocationId();
        }
    }
}

