/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.pathtemplate.ValidationException;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.resourcenames.ResourceName;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LinkName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_BUCKET_LINK = PathTemplate.createWithoutUrlEncoding("projects/{project}/locations/{location}/buckets/{bucket}/links/{link}");
    private static final PathTemplate ORGANIZATION_LOCATION_BUCKET_LINK = PathTemplate.createWithoutUrlEncoding("organizations/{organization}/locations/{location}/buckets/{bucket}/links/{link}");
    private static final PathTemplate FOLDER_LOCATION_BUCKET_LINK = PathTemplate.createWithoutUrlEncoding("folders/{folder}/locations/{location}/buckets/{bucket}/links/{link}");
    private static final PathTemplate BILLING_ACCOUNT_LOCATION_BUCKET_LINK = PathTemplate.createWithoutUrlEncoding("billingAccounts/{billing_account}/locations/{location}/buckets/{bucket}/links/{link}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String bucket;
    private final String link;
    private final String organization;
    private final String folder;
    private final String billingAccount;

    @Deprecated
    protected LinkName() {
        this.project = null;
        this.location = null;
        this.bucket = null;
        this.link = null;
        this.organization = null;
        this.folder = null;
        this.billingAccount = null;
    }

    private LinkName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.location = Preconditions.checkNotNull(builder.getLocation());
        this.bucket = Preconditions.checkNotNull(builder.getBucket());
        this.link = Preconditions.checkNotNull(builder.getLink());
        this.organization = null;
        this.folder = null;
        this.billingAccount = null;
        this.pathTemplate = PROJECT_LOCATION_BUCKET_LINK;
    }

    private LinkName(OrganizationLocationBucketLinkBuilder builder) {
        this.organization = Preconditions.checkNotNull(builder.getOrganization());
        this.location = Preconditions.checkNotNull(builder.getLocation());
        this.bucket = Preconditions.checkNotNull(builder.getBucket());
        this.link = Preconditions.checkNotNull(builder.getLink());
        this.project = null;
        this.folder = null;
        this.billingAccount = null;
        this.pathTemplate = ORGANIZATION_LOCATION_BUCKET_LINK;
    }

    private LinkName(FolderLocationBucketLinkBuilder builder) {
        this.folder = Preconditions.checkNotNull(builder.getFolder());
        this.location = Preconditions.checkNotNull(builder.getLocation());
        this.bucket = Preconditions.checkNotNull(builder.getBucket());
        this.link = Preconditions.checkNotNull(builder.getLink());
        this.project = null;
        this.organization = null;
        this.billingAccount = null;
        this.pathTemplate = FOLDER_LOCATION_BUCKET_LINK;
    }

    private LinkName(BillingAccountLocationBucketLinkBuilder builder) {
        this.billingAccount = Preconditions.checkNotNull(builder.getBillingAccount());
        this.location = Preconditions.checkNotNull(builder.getLocation());
        this.bucket = Preconditions.checkNotNull(builder.getBucket());
        this.link = Preconditions.checkNotNull(builder.getLink());
        this.project = null;
        this.organization = null;
        this.folder = null;
        this.pathTemplate = BILLING_ACCOUNT_LOCATION_BUCKET_LINK;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getLink() {
        return this.link;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getBillingAccount() {
        return this.billingAccount;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationBucketLinkBuilder() {
        return new Builder();
    }

    public static OrganizationLocationBucketLinkBuilder newOrganizationLocationBucketLinkBuilder() {
        return new OrganizationLocationBucketLinkBuilder();
    }

    public static FolderLocationBucketLinkBuilder newFolderLocationBucketLinkBuilder() {
        return new FolderLocationBucketLinkBuilder();
    }

    public static BillingAccountLocationBucketLinkBuilder newBillingAccountLocationBucketLinkBuilder() {
        return new BillingAccountLocationBucketLinkBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LinkName of(String project, String location, String bucket, String link) {
        return LinkName.newBuilder().setProject(project).setLocation(location).setBucket(bucket).setLink(link).build();
    }

    public static LinkName ofProjectLocationBucketLinkName(String project, String location, String bucket, String link) {
        return LinkName.newBuilder().setProject(project).setLocation(location).setBucket(bucket).setLink(link).build();
    }

    public static LinkName ofOrganizationLocationBucketLinkName(String organization, String location, String bucket, String link) {
        return LinkName.newOrganizationLocationBucketLinkBuilder().setOrganization(organization).setLocation(location).setBucket(bucket).setLink(link).build();
    }

    public static LinkName ofFolderLocationBucketLinkName(String folder, String location, String bucket, String link) {
        return LinkName.newFolderLocationBucketLinkBuilder().setFolder(folder).setLocation(location).setBucket(bucket).setLink(link).build();
    }

    public static LinkName ofBillingAccountLocationBucketLinkName(String billingAccount, String location, String bucket, String link) {
        return LinkName.newBillingAccountLocationBucketLinkBuilder().setBillingAccount(billingAccount).setLocation(location).setBucket(bucket).setLink(link).build();
    }

    public static String format(String project, String location, String bucket, String link) {
        return LinkName.newBuilder().setProject(project).setLocation(location).setBucket(bucket).setLink(link).build().toString();
    }

    public static String formatProjectLocationBucketLinkName(String project, String location, String bucket, String link) {
        return LinkName.newBuilder().setProject(project).setLocation(location).setBucket(bucket).setLink(link).build().toString();
    }

    public static String formatOrganizationLocationBucketLinkName(String organization, String location, String bucket, String link) {
        return LinkName.newOrganizationLocationBucketLinkBuilder().setOrganization(organization).setLocation(location).setBucket(bucket).setLink(link).build().toString();
    }

    public static String formatFolderLocationBucketLinkName(String folder, String location, String bucket, String link) {
        return LinkName.newFolderLocationBucketLinkBuilder().setFolder(folder).setLocation(location).setBucket(bucket).setLink(link).build().toString();
    }

    public static String formatBillingAccountLocationBucketLinkName(String billingAccount, String location, String bucket, String link) {
        return LinkName.newBillingAccountLocationBucketLinkBuilder().setBillingAccount(billingAccount).setLocation(location).setBucket(bucket).setLink(link).build().toString();
    }

    public static LinkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_BUCKET_LINK.matches(formattedString)) {
            Map<String, String> matchMap = PROJECT_LOCATION_BUCKET_LINK.match(formattedString);
            return LinkName.ofProjectLocationBucketLinkName(matchMap.get("project"), matchMap.get("location"), matchMap.get("bucket"), matchMap.get("link"));
        }
        if (ORGANIZATION_LOCATION_BUCKET_LINK.matches(formattedString)) {
            Map<String, String> matchMap = ORGANIZATION_LOCATION_BUCKET_LINK.match(formattedString);
            return LinkName.ofOrganizationLocationBucketLinkName(matchMap.get("organization"), matchMap.get("location"), matchMap.get("bucket"), matchMap.get("link"));
        }
        if (FOLDER_LOCATION_BUCKET_LINK.matches(formattedString)) {
            Map<String, String> matchMap = FOLDER_LOCATION_BUCKET_LINK.match(formattedString);
            return LinkName.ofFolderLocationBucketLinkName(matchMap.get("folder"), matchMap.get("location"), matchMap.get("bucket"), matchMap.get("link"));
        }
        if (BILLING_ACCOUNT_LOCATION_BUCKET_LINK.matches(formattedString)) {
            Map<String, String> matchMap = BILLING_ACCOUNT_LOCATION_BUCKET_LINK.match(formattedString);
            return LinkName.ofBillingAccountLocationBucketLinkName(matchMap.get("billing_account"), matchMap.get("location"), matchMap.get("bucket"), matchMap.get("link"));
        }
        throw new ValidationException("LinkName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<LinkName> parseList(List<String> formattedStrings) {
        ArrayList<LinkName> list = new ArrayList<LinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_BUCKET_LINK.matches(formattedString) || ORGANIZATION_LOCATION_BUCKET_LINK.matches(formattedString) || FOLDER_LOCATION_BUCKET_LINK.matches(formattedString) || BILLING_ACCOUNT_LOCATION_BUCKET_LINK.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LinkName linkName = this;
            synchronized (linkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put("location", this.location);
                    }
                    if (this.bucket != null) {
                        fieldMapBuilder.put("bucket", this.bucket);
                    }
                    if (this.link != null) {
                        fieldMapBuilder.put("link", this.link);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put("organization", this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put("folder", this.folder);
                    }
                    if (this.billingAccount != null) {
                        fieldMapBuilder.put("billing_account", this.billingAccount);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            LinkName that = (LinkName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.bucket, that.bucket) && Objects.equals(this.link, that.link) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder) && Objects.equals(this.billingAccount, that.billingAccount);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.bucket);
        h *= 1000003;
        h ^= Objects.hashCode(this.link);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.billingAccount);
    }

    public static class BillingAccountLocationBucketLinkBuilder {
        private String billingAccount;
        private String location;
        private String bucket;
        private String link;

        protected BillingAccountLocationBucketLinkBuilder() {
        }

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public String getLocation() {
            return this.location;
        }

        public String getBucket() {
            return this.bucket;
        }

        public String getLink() {
            return this.link;
        }

        public BillingAccountLocationBucketLinkBuilder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        public BillingAccountLocationBucketLinkBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public BillingAccountLocationBucketLinkBuilder setBucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public BillingAccountLocationBucketLinkBuilder setLink(String link) {
            this.link = link;
            return this;
        }

        public LinkName build() {
            return new LinkName(this);
        }
    }

    public static class FolderLocationBucketLinkBuilder {
        private String folder;
        private String location;
        private String bucket;
        private String link;

        protected FolderLocationBucketLinkBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getLocation() {
            return this.location;
        }

        public String getBucket() {
            return this.bucket;
        }

        public String getLink() {
            return this.link;
        }

        public FolderLocationBucketLinkBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderLocationBucketLinkBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public FolderLocationBucketLinkBuilder setBucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public FolderLocationBucketLinkBuilder setLink(String link) {
            this.link = link;
            return this;
        }

        public LinkName build() {
            return new LinkName(this);
        }
    }

    public static class OrganizationLocationBucketLinkBuilder {
        private String organization;
        private String location;
        private String bucket;
        private String link;

        protected OrganizationLocationBucketLinkBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getBucket() {
            return this.bucket;
        }

        public String getLink() {
            return this.link;
        }

        public OrganizationLocationBucketLinkBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLocationBucketLinkBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public OrganizationLocationBucketLinkBuilder setBucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public OrganizationLocationBucketLinkBuilder setLink(String link) {
            this.link = link;
            return this;
        }

        public LinkName build() {
            return new LinkName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String bucket;
        private String link;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getBucket() {
            return this.bucket;
        }

        public String getLink() {
            return this.link;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setBucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder setLink(String link) {
            this.link = link;
            return this;
        }

        private Builder(LinkName linkName) {
            Preconditions.checkArgument(Objects.equals(linkName.pathTemplate, PROJECT_LOCATION_BUCKET_LINK), "toBuilder is only supported when LinkName has the pattern of projects/{project}/locations/{location}/buckets/{bucket}/links/{link}");
            this.project = linkName.project;
            this.location = linkName.location;
            this.bucket = linkName.bucket;
            this.link = linkName.link;
        }

        public LinkName build() {
            return new LinkName(this);
        }
    }
}

