/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.pathtemplate.ValidationException;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.resourcenames.ResourceName;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LogExclusionName
implements ResourceName {
    private static final PathTemplate PROJECT_EXCLUSION = PathTemplate.createWithoutUrlEncoding("projects/{project}/exclusions/{exclusion}");
    private static final PathTemplate ORGANIZATION_EXCLUSION = PathTemplate.createWithoutUrlEncoding("organizations/{organization}/exclusions/{exclusion}");
    private static final PathTemplate FOLDER_EXCLUSION = PathTemplate.createWithoutUrlEncoding("folders/{folder}/exclusions/{exclusion}");
    private static final PathTemplate BILLING_ACCOUNT_EXCLUSION = PathTemplate.createWithoutUrlEncoding("billingAccounts/{billing_account}/exclusions/{exclusion}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String exclusion;
    private final String organization;
    private final String folder;
    private final String billingAccount;

    @Deprecated
    protected LogExclusionName() {
        this.project = null;
        this.exclusion = null;
        this.organization = null;
        this.folder = null;
        this.billingAccount = null;
    }

    private LogExclusionName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.exclusion = Preconditions.checkNotNull(builder.getExclusion());
        this.organization = null;
        this.folder = null;
        this.billingAccount = null;
        this.pathTemplate = PROJECT_EXCLUSION;
    }

    private LogExclusionName(OrganizationExclusionBuilder builder) {
        this.organization = Preconditions.checkNotNull(builder.getOrganization());
        this.exclusion = Preconditions.checkNotNull(builder.getExclusion());
        this.project = null;
        this.folder = null;
        this.billingAccount = null;
        this.pathTemplate = ORGANIZATION_EXCLUSION;
    }

    private LogExclusionName(FolderExclusionBuilder builder) {
        this.folder = Preconditions.checkNotNull(builder.getFolder());
        this.exclusion = Preconditions.checkNotNull(builder.getExclusion());
        this.project = null;
        this.organization = null;
        this.billingAccount = null;
        this.pathTemplate = FOLDER_EXCLUSION;
    }

    private LogExclusionName(BillingAccountExclusionBuilder builder) {
        this.billingAccount = Preconditions.checkNotNull(builder.getBillingAccount());
        this.exclusion = Preconditions.checkNotNull(builder.getExclusion());
        this.project = null;
        this.organization = null;
        this.folder = null;
        this.pathTemplate = BILLING_ACCOUNT_EXCLUSION;
    }

    public String getProject() {
        return this.project;
    }

    public String getExclusion() {
        return this.exclusion;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getBillingAccount() {
        return this.billingAccount;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectExclusionBuilder() {
        return new Builder();
    }

    public static OrganizationExclusionBuilder newOrganizationExclusionBuilder() {
        return new OrganizationExclusionBuilder();
    }

    public static FolderExclusionBuilder newFolderExclusionBuilder() {
        return new FolderExclusionBuilder();
    }

    public static BillingAccountExclusionBuilder newBillingAccountExclusionBuilder() {
        return new BillingAccountExclusionBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LogExclusionName of(String project, String exclusion) {
        return LogExclusionName.newBuilder().setProject(project).setExclusion(exclusion).build();
    }

    public static LogExclusionName ofProjectExclusionName(String project, String exclusion) {
        return LogExclusionName.newBuilder().setProject(project).setExclusion(exclusion).build();
    }

    public static LogExclusionName ofOrganizationExclusionName(String organization, String exclusion) {
        return LogExclusionName.newOrganizationExclusionBuilder().setOrganization(organization).setExclusion(exclusion).build();
    }

    public static LogExclusionName ofFolderExclusionName(String folder, String exclusion) {
        return LogExclusionName.newFolderExclusionBuilder().setFolder(folder).setExclusion(exclusion).build();
    }

    public static LogExclusionName ofBillingAccountExclusionName(String billingAccount, String exclusion) {
        return LogExclusionName.newBillingAccountExclusionBuilder().setBillingAccount(billingAccount).setExclusion(exclusion).build();
    }

    public static String format(String project, String exclusion) {
        return LogExclusionName.newBuilder().setProject(project).setExclusion(exclusion).build().toString();
    }

    public static String formatProjectExclusionName(String project, String exclusion) {
        return LogExclusionName.newBuilder().setProject(project).setExclusion(exclusion).build().toString();
    }

    public static String formatOrganizationExclusionName(String organization, String exclusion) {
        return LogExclusionName.newOrganizationExclusionBuilder().setOrganization(organization).setExclusion(exclusion).build().toString();
    }

    public static String formatFolderExclusionName(String folder, String exclusion) {
        return LogExclusionName.newFolderExclusionBuilder().setFolder(folder).setExclusion(exclusion).build().toString();
    }

    public static String formatBillingAccountExclusionName(String billingAccount, String exclusion) {
        return LogExclusionName.newBillingAccountExclusionBuilder().setBillingAccount(billingAccount).setExclusion(exclusion).build().toString();
    }

    public static LogExclusionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_EXCLUSION.matches(formattedString)) {
            Map<String, String> matchMap = PROJECT_EXCLUSION.match(formattedString);
            return LogExclusionName.ofProjectExclusionName(matchMap.get("project"), matchMap.get("exclusion"));
        }
        if (ORGANIZATION_EXCLUSION.matches(formattedString)) {
            Map<String, String> matchMap = ORGANIZATION_EXCLUSION.match(formattedString);
            return LogExclusionName.ofOrganizationExclusionName(matchMap.get("organization"), matchMap.get("exclusion"));
        }
        if (FOLDER_EXCLUSION.matches(formattedString)) {
            Map<String, String> matchMap = FOLDER_EXCLUSION.match(formattedString);
            return LogExclusionName.ofFolderExclusionName(matchMap.get("folder"), matchMap.get("exclusion"));
        }
        if (BILLING_ACCOUNT_EXCLUSION.matches(formattedString)) {
            Map<String, String> matchMap = BILLING_ACCOUNT_EXCLUSION.match(formattedString);
            return LogExclusionName.ofBillingAccountExclusionName(matchMap.get("billing_account"), matchMap.get("exclusion"));
        }
        throw new ValidationException("LogExclusionName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<LogExclusionName> parseList(List<String> formattedStrings) {
        ArrayList<LogExclusionName> list = new ArrayList<LogExclusionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LogExclusionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LogExclusionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LogExclusionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_EXCLUSION.matches(formattedString) || ORGANIZATION_EXCLUSION.matches(formattedString) || FOLDER_EXCLUSION.matches(formattedString) || BILLING_ACCOUNT_EXCLUSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LogExclusionName logExclusionName = this;
            synchronized (logExclusionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.exclusion != null) {
                        fieldMapBuilder.put("exclusion", this.exclusion);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put("organization", this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put("folder", this.folder);
                    }
                    if (this.billingAccount != null) {
                        fieldMapBuilder.put("billing_account", this.billingAccount);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            LogExclusionName that = (LogExclusionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.exclusion, that.exclusion) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder) && Objects.equals(this.billingAccount, that.billingAccount);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.exclusion);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.billingAccount);
    }

    public static class BillingAccountExclusionBuilder {
        private String billingAccount;
        private String exclusion;

        protected BillingAccountExclusionBuilder() {
        }

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public String getExclusion() {
            return this.exclusion;
        }

        public BillingAccountExclusionBuilder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        public BillingAccountExclusionBuilder setExclusion(String exclusion) {
            this.exclusion = exclusion;
            return this;
        }

        public LogExclusionName build() {
            return new LogExclusionName(this);
        }
    }

    public static class FolderExclusionBuilder {
        private String folder;
        private String exclusion;

        protected FolderExclusionBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getExclusion() {
            return this.exclusion;
        }

        public FolderExclusionBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderExclusionBuilder setExclusion(String exclusion) {
            this.exclusion = exclusion;
            return this;
        }

        public LogExclusionName build() {
            return new LogExclusionName(this);
        }
    }

    public static class OrganizationExclusionBuilder {
        private String organization;
        private String exclusion;

        protected OrganizationExclusionBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getExclusion() {
            return this.exclusion;
        }

        public OrganizationExclusionBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationExclusionBuilder setExclusion(String exclusion) {
            this.exclusion = exclusion;
            return this;
        }

        public LogExclusionName build() {
            return new LogExclusionName(this);
        }
    }

    public static class Builder {
        private String project;
        private String exclusion;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getExclusion() {
            return this.exclusion;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setExclusion(String exclusion) {
            this.exclusion = exclusion;
            return this;
        }

        private Builder(LogExclusionName logExclusionName) {
            Preconditions.checkArgument(Objects.equals(logExclusionName.pathTemplate, PROJECT_EXCLUSION), "toBuilder is only supported when LogExclusionName has the pattern of projects/{project}/exclusions/{exclusion}");
            this.project = logExclusionName.project;
            this.exclusion = logExclusionName.exclusion;
        }

        public LogExclusionName build() {
            return new LogExclusionName(this);
        }
    }
}

