/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.resourcenames.ResourceName;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OrganizationLocationName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION = PathTemplate.createWithoutUrlEncoding("organizations/{organization}/locations/{location}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String location;

    @Deprecated
    protected OrganizationLocationName() {
        this.organization = null;
        this.location = null;
    }

    private OrganizationLocationName(Builder builder) {
        this.organization = Preconditions.checkNotNull(builder.getOrganization());
        this.location = Preconditions.checkNotNull(builder.getLocation());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static OrganizationLocationName of(String organization, String location) {
        return OrganizationLocationName.newBuilder().setOrganization(organization).setLocation(location).build();
    }

    public static String format(String organization, String location) {
        return OrganizationLocationName.newBuilder().setOrganization(organization).setLocation(location).build().toString();
    }

    public static OrganizationLocationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = ORGANIZATION_LOCATION.validatedMatch(formattedString, "OrganizationLocationName.parse: formattedString not in valid format");
        return OrganizationLocationName.of(matchMap.get("organization"), matchMap.get("location"));
    }

    public static List<OrganizationLocationName> parseList(List<String> formattedStrings) {
        ArrayList<OrganizationLocationName> list = new ArrayList<OrganizationLocationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(OrganizationLocationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<OrganizationLocationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (OrganizationLocationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            OrganizationLocationName organizationLocationName = this;
            synchronized (organizationLocationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put("organization", this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put("location", this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_LOCATION.instantiate("organization", this.organization, "location", this.location);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            OrganizationLocationName that = (OrganizationLocationName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    public static class Builder {
        private String organization;
        private String location;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        private Builder(OrganizationLocationName organizationLocationName) {
            this.organization = organizationLocationName.organization;
            this.location = organizationLocationName.location;
        }

        public OrganizationLocationName build() {
            return new OrganizationLocationName(this);
        }
    }
}

