/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.common;

import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.common.ArrayBackedAttributes;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.common.AttributeKey;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.common.Attributes;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.common.AttributesBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

class ArrayBackedAttributesBuilder
implements AttributesBuilder {
    private final List<Object> data;

    ArrayBackedAttributesBuilder() {
        this.data = new ArrayList<Object>();
    }

    ArrayBackedAttributesBuilder(List<Object> data) {
        this.data = data;
    }

    @Override
    public Attributes build() {
        if (this.data.size() == 2 && this.data.get(0) != null) {
            return new ArrayBackedAttributes(this.data.toArray());
        }
        return ArrayBackedAttributes.sortAndFilterToAttributes(this.data.toArray());
    }

    @Override
    public <T> AttributesBuilder put(AttributeKey<Long> key, int value) {
        return this.put((AttributeKey<T>)key, (T)Long.valueOf(value));
    }

    @Override
    public <T> AttributesBuilder put(AttributeKey<T> key, T value) {
        if (key == null || key.getKey().isEmpty() || value == null) {
            return this;
        }
        this.data.add(key);
        this.data.add(value);
        return this;
    }

    @Override
    public AttributesBuilder putAll(Attributes attributes) {
        if (attributes == null) {
            return this;
        }
        attributes.forEach((key, value) -> this.put((AttributeKey<T>)((AttributeKey)key), (T)value));
        return this;
    }

    @Override
    public <T> AttributesBuilder remove(AttributeKey<T> key) {
        if (key == null || key.getKey().isEmpty()) {
            return this;
        }
        return this.removeIf(entryKey -> key.getKey().equals(entryKey.getKey()) && key.getType().equals((Object)entryKey.getType()));
    }

    @Override
    public AttributesBuilder removeIf(Predicate<AttributeKey<?>> predicate) {
        if (predicate == null) {
            return this;
        }
        for (int i = 0; i < this.data.size() - 1; i += 2) {
            Object entry = this.data.get(i);
            if (!(entry instanceof AttributeKey) || !predicate.test((AttributeKey)entry)) continue;
            this.data.set(i, null);
            this.data.set(i + 1, null);
        }
        return this;
    }

    static List<Double> toList(double ... values) {
        Double[] boxed = new Double[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return Arrays.asList(boxed);
    }

    static List<Long> toList(long ... values) {
        Long[] boxed = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return Arrays.asList(boxed);
    }

    static List<Boolean> toList(boolean ... values) {
        Boolean[] boxed = new Boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return Arrays.asList(boxed);
    }
}

