/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics;

import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.common.Attributes;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.metrics.DoubleHistogram;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.metrics.LongHistogramBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.context.Context;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.internal.ThrottlingLogger;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.AbstractInstrument;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.InstrumentBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.InstrumentType;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.InstrumentValueType;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.SdkLongHistogram;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.SdkMeter;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.internal.aggregator.ExplicitBucketHistogramUtils;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

class SdkDoubleHistogram
extends AbstractInstrument
implements DoubleHistogram {
    private static final Logger logger = Logger.getLogger(SdkDoubleHistogram.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    final SdkMeter sdkMeter;
    final WriteableMetricStorage storage;

    SdkDoubleHistogram(InstrumentDescriptor descriptor, SdkMeter sdkMeter, WriteableMetricStorage storage) {
        super(descriptor);
        this.sdkMeter = sdkMeter;
        this.storage = storage;
    }

    @Override
    public void record(double value, Attributes attributes, Context context) {
        if (value < 0.0) {
            this.throttlingLogger.log(Level.WARNING, "Histograms can only record non-negative values. Instrument " + this.getDescriptor().getName() + " has recorded a negative value.");
            return;
        }
        this.storage.recordDouble(value, attributes, context);
    }

    @Override
    public void record(double value, Attributes attributes) {
        this.record(value, attributes, Context.current());
    }

    @Override
    public void record(double value) {
        this.record(value, Attributes.empty());
    }

    static class SdkDoubleHistogramBuilder
    implements DoubleHistogramBuilder {
        final InstrumentBuilder builder;

        SdkDoubleHistogramBuilder(SdkMeter sdkMeter, String name) {
            this.builder = new InstrumentBuilder(name, InstrumentType.HISTOGRAM, InstrumentValueType.DOUBLE, sdkMeter);
        }

        @Override
        public DoubleHistogramBuilder setDescription(String description) {
            this.builder.setDescription(description);
            return this;
        }

        @Override
        public DoubleHistogramBuilder setUnit(String unit) {
            this.builder.setUnit(unit);
            return this;
        }

        @Override
        public SdkDoubleHistogram build() {
            return this.builder.buildSynchronousInstrument(SdkDoubleHistogram::new);
        }

        @Override
        public LongHistogramBuilder ofLongs() {
            return this.builder.swapBuilder(SdkLongHistogram.SdkLongHistogramBuilder::new);
        }

        @Override
        public DoubleHistogramBuilder setExplicitBucketBoundariesAdvice(List<Double> bucketBoundaries) {
            try {
                Objects.requireNonNull(bucketBoundaries, "bucketBoundaries must not be null");
                ExplicitBucketHistogramUtils.validateBucketBoundaries(bucketBoundaries);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                logger.warning("Error setting explicit bucket boundaries advice: " + e.getMessage());
                return this;
            }
            this.builder.setExplicitBucketBoundaries(bucketBoundaries);
            return this;
        }

        public String toString() {
            return this.builder.toStringHelper(this.getClass().getSimpleName());
        }
    }
}

