/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.LogName;
import com.google.cloud.logging.Option;
import java.util.Map;

public final class LogDestinationName
extends Option {
    private static final long serialVersionUID = 7944256748441111191L;

    private LogDestinationName(Option.OptionType option, Object value) {
        super(option, value);
        Preconditions.checkArgument(!Preconditions.checkNotNull(value).toString().trim().isEmpty());
    }

    public static LogDestinationName project(String id) {
        return new LogDestinationName(DestinationType.PROJECT, id);
    }

    public static LogDestinationName folder(String id) {
        return new LogDestinationName(DestinationType.FOLDER, id);
    }

    public static LogDestinationName organization(String id) {
        return new LogDestinationName(DestinationType.ORGANIZATION, id);
    }

    public static LogDestinationName billingAccount(String id) {
        return new LogDestinationName(DestinationType.BILLINGACCOUNT, id);
    }

    public LogName toLogName(String logId) {
        if (logId == null) {
            return null;
        }
        switch ((DestinationType)this.getOptionType()) {
            case PROJECT: {
                return LogName.ofProjectLogName(this.getValue().toString(), logId);
            }
            case FOLDER: {
                return LogName.ofFolderLogName(this.getValue().toString(), logId);
            }
            case ORGANIZATION: {
                return LogName.ofOrganizationLogName(this.getValue().toString(), logId);
            }
            case BILLINGACCOUNT: {
                return LogName.ofBillingAccountLogName(this.getValue().toString(), logId);
            }
        }
        return null;
    }

    public String getDestinationId() {
        return this.getValue().toString();
    }

    public DestinationType getDestinationType() {
        return (DestinationType)this.getOptionType();
    }

    public static LogDestinationName fromLogName(LogName logName) {
        if (logName == null) {
            return null;
        }
        if (logName.getProject() != null) {
            return LogDestinationName.project(logName.getProject());
        }
        if (logName.getBillingAccount() != null) {
            return LogDestinationName.billingAccount(logName.getBillingAccount());
        }
        if (logName.getFolder() != null) {
            return LogDestinationName.folder(logName.getFolder());
        }
        if (logName.getOrganization() != null) {
            return LogDestinationName.organization(logName.getOrganization());
        }
        return null;
    }

    public static enum DestinationType implements Option.OptionType
    {
        PROJECT,
        FOLDER,
        ORGANIZATION,
        BILLINGACCOUNT;


        <T> T get(Map<Option.OptionType, ?> options) {
            return (T)options.get(this);
        }
    }
}

