/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.MonitoredResource;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Function;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import com.google.cloud.hadoop.repackaged.gcs.com.google.gson.Gson;
import com.google.cloud.hadoop.repackaged.gcs.com.google.gson.GsonBuilder;
import com.google.cloud.hadoop.repackaged.gcs.com.google.gson.JsonElement;
import com.google.cloud.hadoop.repackaged.gcs.com.google.gson.JsonObject;
import com.google.cloud.hadoop.repackaged.gcs.com.google.gson.JsonPrimitive;
import com.google.cloud.hadoop.repackaged.gcs.com.google.gson.JsonSerializationContext;
import com.google.cloud.hadoop.repackaged.gcs.com.google.gson.JsonSerializer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.LogEntry;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.LogEntryOperation;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.LogEntrySourceLocation;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.LogName;
import com.google.cloud.logging.HttpRequest;
import com.google.cloud.logging.JavaTimeConversions;
import com.google.cloud.logging.LogDestinationName;
import com.google.cloud.logging.Operation;
import com.google.cloud.logging.Payload;
import com.google.cloud.logging.Severity;
import com.google.cloud.logging.SourceLocation;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class LogEntry
implements Serializable {
    private static final long serialVersionUID = -944788159728228219L;
    static final Function<com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.LogEntry, LogEntry> FROM_PB_FUNCTION = pb -> LogEntry.fromPb(pb);
    private final String logName;
    private final MonitoredResource resource;
    private final Instant timestamp;
    private final Instant receiveTimestamp;
    private final Severity severity;
    private final String insertId;
    private final HttpRequest httpRequest;
    private final ImmutableMap<String, String> labels;
    private final Operation operation;
    private final String trace;
    private final String spanId;
    private final boolean traceSampled;
    private final SourceLocation sourceLocation;
    private final Payload<?> payload;
    private final LogDestinationName destination;

    LogEntry(Builder builder) {
        this.logName = builder.logName;
        this.resource = builder.resource;
        this.timestamp = builder.timestamp;
        this.receiveTimestamp = builder.receiveTimestamp;
        this.severity = builder.severity;
        this.insertId = builder.insertId;
        this.httpRequest = builder.httpRequest;
        this.labels = ImmutableMap.copyOf(builder.labels);
        this.operation = builder.operation;
        this.trace = builder.trace;
        this.spanId = builder.spanId;
        this.traceSampled = builder.traceSampled;
        this.sourceLocation = builder.sourceLocation;
        this.payload = builder.payload;
        this.destination = builder.destination;
    }

    public String getLogName() {
        return this.logName;
    }

    public MonitoredResource getResource() {
        return this.resource;
    }

    @Deprecated
    public Long getTimestamp() {
        return this.timestamp != null ? Long.valueOf(this.timestamp.toEpochMilli()) : null;
    }

    public Instant getInstantTimestamp() {
        return this.timestamp;
    }

    @Deprecated
    public Long getReceiveTimestamp() {
        return this.receiveTimestamp != null ? Long.valueOf(this.receiveTimestamp.toEpochMilli()) : null;
    }

    public Instant getInstantReceiveTimestamp() {
        return this.receiveTimestamp;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getInsertId() {
        return this.insertId;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getTrace() {
        return this.trace == null ? null : this.trace;
    }

    public String getSpanId() {
        return this.spanId == null ? null : this.spanId;
    }

    public boolean getTraceSampled() {
        return this.traceSampled;
    }

    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public <T extends Payload<?>> T getPayload() {
        return (T)this.payload;
    }

    public LogDestinationName getDestination() {
        return this.destination;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.logName, this.resource, this.timestamp, this.receiveTimestamp, this.severity, this.insertId, this.httpRequest, this.labels, this.operation, this.getTrace(), this.getSpanId(), this.traceSampled, this.sourceLocation, this.payload, this.destination});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LogEntry)) {
            return false;
        }
        LogEntry other = (LogEntry)obj;
        return Objects.equals(this.logName, other.logName) && Objects.equals(this.resource, other.resource) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.receiveTimestamp, other.receiveTimestamp) && Objects.equals((Object)this.severity, (Object)other.severity) && Objects.equals(this.insertId, other.insertId) && Objects.equals(this.httpRequest, other.httpRequest) && Objects.equals(this.labels, other.labels) && Objects.equals(this.operation, other.operation) && Objects.equals(this.getTrace(), other.getTrace()) && Objects.equals(this.getSpanId(), other.getSpanId()) && this.traceSampled == other.traceSampled && Objects.equals(this.sourceLocation, other.sourceLocation) && Objects.equals(this.payload, other.payload) && Objects.equals(this.destination, other.destination);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("logName", this.logName).add("resource", this.resource).add("timestamp", this.timestamp).add("receiveTimestamp", this.receiveTimestamp).add("severity", (Object)this.severity).add("insertId", this.insertId).add("httpRequest", this.httpRequest).add("labels", this.labels).add("operation", this.operation).add("trace", this.trace).add("spanId", this.spanId).add("traceSampled", this.traceSampled).add("sourceLocation", this.sourceLocation).add("payload", this.payload).add("destination", this.destination).toString();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.LogEntry toPb(String projectId) {
        LogEntry.Builder builder = this.payload.toPb();
        builder.putAllLabels(this.labels);
        if (this.logName != null) {
            if (this.destination == null) {
                builder.setLogName(LogName.ofProjectLogName(projectId, this.logName).toString());
            } else {
                builder.setLogName(this.destination.toLogName(this.logName).toString());
            }
        }
        if (this.resource != null) {
            builder.setResource(this.resource.toPb());
        }
        if (this.timestamp != null) {
            builder.setTimestamp(JavaTimeConversions.toProtoTimestamp(this.timestamp));
        }
        if (this.receiveTimestamp != null) {
            builder.setReceiveTimestamp(JavaTimeConversions.toProtoTimestamp(this.receiveTimestamp));
        }
        if (this.severity != null) {
            builder.setSeverity(this.severity.toPb());
        }
        if (this.insertId != null) {
            builder.setInsertId(this.insertId);
        }
        if (this.httpRequest != null) {
            builder.setHttpRequest(this.httpRequest.toPb());
        }
        if (this.operation != null) {
            builder.setOperation(this.operation.toPb());
        }
        if (this.trace != null) {
            builder.setTrace(this.getTrace());
        }
        if (this.spanId != null) {
            builder.setSpanId(this.getSpanId());
        }
        builder.setTraceSampled(this.traceSampled);
        if (this.sourceLocation != null) {
            builder.setSourceLocation(this.sourceLocation.toPb());
        }
        return builder.build();
    }

    public String toStructuredJsonString() {
        if (this.payload.getType() == Payload.Type.PROTO) {
            throw new UnsupportedOperationException("LogEntry with protobuf payload cannot be converted");
        }
        if (this.severity == Severity.NONE) {
            throw new IllegalArgumentException("Severity.NONE cannot be used for LogEntry");
        }
        StringBuilder builder = new StringBuilder("{");
        StructuredLogFormatter formatter = new StructuredLogFormatter(builder);
        formatter.appendField("severity", (Object)this.severity).appendField("time", this.timestamp).appendField("httpRequest", this.httpRequest).appendField("logging.googleapis.com/insertId", this.insertId).appendField("logging.googleapis.com/labels", this.labels).appendField("logging.googleapis.com/operation", this.operation).appendField("logging.googleapis.com/sourceLocation", this.sourceLocation).appendField("logging.googleapis.com/spanId", this.spanId).appendField("logging.googleapis.com/trace", this.trace).appendField("logging.googleapis.com/trace_sampled", this.traceSampled);
        if (this.payload.getType() == Payload.Type.STRING) {
            formatter.appendField("message", this.payload.getData(), false);
        } else if (this.payload.getType() == Payload.Type.JSON) {
            Payload.JsonPayload jsonPayload = (Payload.JsonPayload)this.payload;
            formatter.appendDict(jsonPayload.getDataAsMap(), false);
        }
        builder.append("}");
        return builder.toString();
    }

    public static Builder newBuilder(Payload<?> payload) {
        return new Builder(payload);
    }

    public static LogEntry of(Payload<?> payload) {
        return LogEntry.newBuilder(payload).build();
    }

    public static LogEntry of(String logName, MonitoredResource resource, Payload<?> payload) {
        return LogEntry.newBuilder(payload).setLogName(logName).setResource(resource).build();
    }

    public static LogEntry fromPb(com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.LogEntry entryPb) {
        Builder builder = LogEntry.newBuilder(Payload.fromPb(entryPb));
        builder.setLabels(entryPb.getLabelsMap());
        builder.setSeverity(Severity.fromPb(entryPb.getSeverity()));
        if (!entryPb.getLogName().isEmpty()) {
            LogName name = LogName.parse(entryPb.getLogName());
            builder.setLogName(name.getLog());
            LogDestinationName resource = LogDestinationName.fromLogName(name);
            if (resource != null) {
                builder.setDestination(resource);
            }
        }
        if (!entryPb.getResource().equals(com.google.cloud.hadoop.repackaged.gcs.com.google.api.MonitoredResource.getDefaultInstance())) {
            builder.setResource(MonitoredResource.fromPb(entryPb.getResource()));
        }
        if (entryPb.hasTimestamp()) {
            builder.setTimestamp(JavaTimeConversions.toJavaInstant(entryPb.getTimestamp()));
        }
        if (entryPb.hasReceiveTimestamp()) {
            builder.setReceiveTimestamp(JavaTimeConversions.toJavaInstant(entryPb.getReceiveTimestamp()));
        }
        if (!entryPb.getInsertId().isEmpty()) {
            builder.setInsertId(entryPb.getInsertId());
        }
        if (!entryPb.getHttpRequest().equals(com.google.cloud.hadoop.repackaged.gcs.com.google.logging.type.HttpRequest.getDefaultInstance())) {
            builder.setHttpRequest(HttpRequest.fromPb(entryPb.getHttpRequest()));
        }
        if (!entryPb.getOperation().equals(LogEntryOperation.getDefaultInstance())) {
            builder.setOperation(Operation.fromPb(entryPb.getOperation()));
        }
        if (!entryPb.getTrace().isEmpty()) {
            builder.setTrace(entryPb.getTrace());
        }
        if (!entryPb.getSpanId().isEmpty()) {
            builder.setSpanId(entryPb.getSpanId());
        }
        builder.setTraceSampled(entryPb.getTraceSampled());
        if (!entryPb.getSourceLocation().equals(LogEntrySourceLocation.getDefaultInstance())) {
            builder.setSourceLocation(SourceLocation.fromPb(entryPb.getSourceLocation()));
        }
        return builder.build();
    }

    public static Function<LogEntry, com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.LogEntry> toPbFunction(String projectId) {
        return entry -> entry.toPb(projectId);
    }

    public static class Builder {
        private String logName;
        private MonitoredResource resource;
        private Instant timestamp;
        private Instant receiveTimestamp;
        private Severity severity = Severity.DEFAULT;
        private String insertId;
        private HttpRequest httpRequest;
        private Map<String, String> labels = new HashMap<String, String>();
        private Operation operation;
        private String trace;
        private String spanId;
        private boolean traceSampled;
        private SourceLocation sourceLocation;
        private Payload<?> payload;
        private LogDestinationName destination;

        Builder(Payload<?> payload) {
            this.payload = payload;
        }

        Builder(LogEntry entry) {
            this.logName = entry.logName;
            this.resource = entry.resource;
            this.timestamp = entry.timestamp;
            this.receiveTimestamp = entry.receiveTimestamp;
            this.severity = entry.severity;
            this.insertId = entry.insertId;
            this.httpRequest = entry.httpRequest;
            this.labels = new HashMap<String, String>(entry.labels);
            this.operation = entry.operation;
            this.trace = entry.trace;
            this.spanId = entry.spanId;
            this.traceSampled = entry.traceSampled;
            this.sourceLocation = entry.sourceLocation;
            this.payload = entry.payload;
            this.destination = entry.destination;
        }

        @CanIgnoreReturnValue
        public Builder setLogName(String logName) {
            this.logName = logName;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setResource(MonitoredResource resource) {
            this.resource = resource;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder setTimestamp(long milliseconds) {
            this.timestamp = Instant.ofEpochMilli(milliseconds);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder setReceiveTimestamp(long milliseconds) {
            this.receiveTimestamp = Instant.ofEpochMilli(milliseconds);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setReceiveTimestamp(Instant receiveTimestamp) {
            this.receiveTimestamp = receiveTimestamp;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSeverity(Severity severity) {
            this.severity = severity;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setInsertId(String insertId) {
            this.insertId = insertId;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setHttpRequest(HttpRequest httpRequest) {
            this.httpRequest = httpRequest;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setLabels(Map<String, String> labels) {
            this.labels = new HashMap<String, String>(Preconditions.checkNotNull(labels));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addLabel(String key, String value) {
            this.labels.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clearLabels() {
            this.labels.clear();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setOperation(Operation operation) {
            this.operation = operation;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTrace(String trace) {
            this.trace = trace;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTrace(Object trace) {
            this.trace = trace != null ? trace.toString() : null;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSpanId(String spanId) {
            this.spanId = spanId;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSpanId(Object spanId) {
            this.spanId = spanId != null ? spanId.toString() : null;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTraceSampled(boolean traceSampled) {
            this.traceSampled = traceSampled;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPayload(Payload<?> payload) {
            this.payload = payload;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setDestination(LogDestinationName destination) {
            this.destination = destination;
            return this;
        }

        public LogEntry build() {
            return new LogEntry(this);
        }
    }

    static final class StructuredLogFormatter {
        private final Gson gson;
        private final StringBuilder builder;

        public StructuredLogFormatter(StringBuilder builder) {
            Preconditions.checkNotNull(builder);
            this.gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Duration.class), new DurationSerializer()).registerTypeAdapter((Type)((Object)Instant.class), new InstantSerializer()).registerTypeAdapter((Type)((Object)SourceLocation.class), new SourceLocationSerializer()).registerTypeAdapter((Type)((Object)HttpRequest.RequestMethod.class), new RequestMethodSerializer()).create();
            this.builder = builder;
        }

        @CanIgnoreReturnValue
        public StructuredLogFormatter appendField(String name, Object value, boolean appendComma) {
            Preconditions.checkNotNull(name);
            if (value != null) {
                this.builder.append(this.gson.toJson(name)).append(":").append(this.gson.toJson(value));
                if (appendComma) {
                    this.builder.append(",");
                }
            }
            return this;
        }

        @CanIgnoreReturnValue
        public StructuredLogFormatter appendField(String name, Object value) {
            return this.appendField(name, value, true);
        }

        @CanIgnoreReturnValue
        public StructuredLogFormatter appendDict(Map<String, Object> value, boolean appendComma) {
            String json;
            if (value != null && (json = this.gson.toJson(value)).length() > 1) {
                this.builder.append(json.substring(0, json.length() - 1).substring(1));
                if (appendComma) {
                    this.builder.append(",");
                }
            }
            return this;
        }
    }

    static final class RequestMethodSerializer
    implements JsonSerializer<HttpRequest.RequestMethod> {
        RequestMethodSerializer() {
        }

        @Override
        public JsonElement serialize(HttpRequest.RequestMethod src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.name());
        }
    }

    static final class SourceLocationSerializer
    implements JsonSerializer<SourceLocation> {
        SourceLocationSerializer() {
        }

        @Override
        public JsonElement serialize(SourceLocation src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            if (src.getFile() != null) {
                obj.addProperty("file", src.getFile());
            }
            if (src.getLine() != null) {
                obj.addProperty("line", src.getLine().toString());
            }
            if (src.getFunction() != null) {
                obj.addProperty("function", src.getFunction());
            }
            return obj;
        }
    }

    static final class DurationSerializer
    implements JsonSerializer<Duration> {
        DurationSerializer() {
        }

        @Override
        public JsonElement serialize(Duration src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }
    }

    static final class InstantSerializer
    implements JsonSerializer<Instant> {
        InstantSerializer() {
        }

        @Override
        public JsonElement serialize(Instant src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }
    }
}

