/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.Lists;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.TailLogEntriesResponse;
import com.google.cloud.logging.LogEntry;
import java.util.ArrayDeque;
import java.util.Iterator;

public class LogEntryIterator
implements Iterator<LogEntry> {
    private final Iterator<TailLogEntriesResponse> streamIterator;
    private final ArrayDeque<LogEntry> buffer = new ArrayDeque();

    LogEntryIterator(Iterator<TailLogEntriesResponse> streamIterator) {
        this.streamIterator = streamIterator;
    }

    @Override
    public boolean hasNext() {
        return !this.buffer.isEmpty() || this.streamIterator.hasNext();
    }

    @Override
    public LogEntry next() {
        if (this.buffer.isEmpty()) {
            TailLogEntriesResponse response = this.streamIterator.next();
            this.buffer.addAll(Lists.transform(response.getEntriesList(), LogEntry.FROM_PB_FUNCTION));
        }
        return this.buffer.pop();
    }
}

