/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.spi.v2;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.ApiFunction;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.ApiFuture;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.ApiFutures;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.batching.BatchingSettings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.batching.FlowController;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.core.BackgroundResource;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.core.GaxProperties;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.grpc.GrpcCallContext;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.ApiException;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.BidiStream;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.ClientContext;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.StatusCode;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.NoCredentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.ServiceOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableSet;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.MoreExecutors;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.CreateExclusionRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.CreateLogMetricRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.CreateSinkRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.DeleteExclusionRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.DeleteLogMetricRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.DeleteLogRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.DeleteSinkRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.GetExclusionRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.GetLogMetricRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.GetSinkRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.ListExclusionsRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.ListExclusionsResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.ListLogEntriesRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.ListLogEntriesResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.ListLogMetricsRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.ListLogMetricsResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.ListLogsRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.ListLogsResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.ListMonitoredResourceDescriptorsRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.ListMonitoredResourceDescriptorsResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.ListSinksRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.ListSinksResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.LogExclusion;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.LogMetric;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.LogSink;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.TailLogEntriesRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.TailLogEntriesResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.UpdateExclusionRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.UpdateLogMetricRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.UpdateSinkRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.WriteLogEntriesRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2.WriteLogEntriesResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.Empty;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.CallOptions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ManagedChannel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ManagedChannelBuilder;
import com.google.cloud.logging.LoggingException;
import com.google.cloud.logging.LoggingOptions;
import com.google.cloud.logging.spi.v2.LoggingRpc;
import com.google.cloud.logging.v2.ConfigClient;
import com.google.cloud.logging.v2.ConfigSettings;
import com.google.cloud.logging.v2.LoggingClient;
import com.google.cloud.logging.v2.LoggingSettings;
import com.google.cloud.logging.v2.MetricsClient;
import com.google.cloud.logging.v2.MetricsSettings;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;

public class GrpcLoggingRpc
implements LoggingRpc {
    private final ConfigClient configClient;
    private final LoggingClient loggingClient;
    private final MetricsClient metricsClient;
    private final ScheduledExecutorService executor;
    private final ClientContext clientContext;
    private final GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> executorFactory;
    private boolean closed;

    public GrpcLoggingRpc(final LoggingOptions options) throws IOException {
        GrpcTransportOptions transportOptions = (GrpcTransportOptions)options.getTransportOptions();
        this.executorFactory = transportOptions.getExecutorFactory();
        this.executor = this.executorFactory.get();
        try {
            block11: {
                if (options.getHost().contains("localhost") || NoCredentials.getInstance().equals(options.getCredentials())) {
                    ManagedChannel managedChannel = ((ManagedChannelBuilder)((ManagedChannelBuilder)ManagedChannelBuilder.forTarget(options.getHost()).usePlaintext()).executor(this.executor)).build();
                    try (GrpcTransportChannel transportChannel = GrpcTransportChannel.create(managedChannel);){
                        this.clientContext = ClientContext.newBuilder().setCredentials(null).setExecutor(this.executor).setTransportChannel(transportChannel).setDefaultCallContext(GrpcCallContext.of(managedChannel, CallOptions.DEFAULT)).setBackgroundResources(Collections.singletonList(transportChannel)).setQuotaProjectId(options.getQuotaProjectId()).build();
                        break block11;
                    }
                    catch (Exception ex) {
                        throw new IOException(ex);
                    }
                }
                LoggingSettingsBuilder settingsBuilder = new LoggingSettingsBuilder(LoggingSettings.newBuilder().build());
                settingsBuilder.setCredentialsProvider(GrpcTransportOptions.setUpCredentialsProvider(options));
                settingsBuilder.setTransportChannelProvider(GrpcTransportOptions.setUpChannelProvider(LoggingSettings.defaultGrpcTransportProviderBuilder(), options));
                ApiClientHeaderProvider internalHeaderProvider = LoggingSettings.defaultApiClientHeaderProviderBuilder().setClientLibToken(ServiceOptions.getGoogApiClientLibName(), GaxProperties.getLibraryVersion(options.getClass())).build();
                HeaderProvider headerProvider = options.getMergedHeaderProvider(internalHeaderProvider);
                settingsBuilder.setInternalHeaderProvider(headerProvider);
                settingsBuilder.setQuotaProjectId(options.getQuotaProjectId());
                this.clientContext = ClientContext.create(settingsBuilder.build());
            }
            ApiFunction retrySettingsSetter = new ApiFunction<UnaryCallSettings.Builder<?, ?>, Void>(){

                @Override
                public Void apply(UnaryCallSettings.Builder<?, ?> builder) {
                    builder.setRetrySettings(options.getRetrySettings());
                    return null;
                }
            };
            ConfigSettings.Builder confBuilder = ConfigSettings.newBuilder(this.clientContext).applyToAllUnaryMethods(retrySettingsSetter);
            LoggingSettings.Builder logBuilder = LoggingSettings.newBuilder(this.clientContext).applyToAllUnaryMethods(retrySettingsSetter);
            MetricsSettings.Builder metricsBuilder = MetricsSettings.newBuilder(this.clientContext).applyToAllUnaryMethods(retrySettingsSetter);
            BatchingSettings defaultBatchSettings = logBuilder.writeLogEntriesSettings().getBatchingSettings();
            BatchingSettings batchingSettings = options.getBatchingSettings();
            logBuilder.writeLogEntriesSettings().setBatchingSettings(batchingSettings != null ? batchingSettings : defaultBatchSettings.toBuilder().setFlowControlSettings(defaultBatchSettings.getFlowControlSettings().toBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block).build()).build());
            this.configClient = ConfigClient.create(confBuilder.build());
            this.loggingClient = LoggingClient.create(logBuilder.build());
            this.metricsClient = MetricsClient.create(metricsBuilder.build());
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private static <V> ApiFuture<V> translate(ApiFuture<V> from, StatusCode.Code ... returnNullOn) {
        AbstractCollection returnNullOnSet = returnNullOn.length > 0 ? EnumSet.of(returnNullOn[0], returnNullOn) : ImmutableSet.of();
        return ApiFutures.catching(from, ApiException.class, new ApiFunction<ApiException, V>((Set)returnNullOnSet){
            final /* synthetic */ Set val$returnNullOnSet;
            {
                this.val$returnNullOnSet = set;
            }

            @Override
            public V apply(ApiException exception) {
                if (this.val$returnNullOnSet.contains((Object)exception.getStatusCode().getCode())) {
                    return null;
                }
                throw new LoggingException(exception);
            }
        }, MoreExecutors.directExecutor());
    }

    @Override
    public ApiFuture<LogSink> create(CreateSinkRequest request) {
        return GrpcLoggingRpc.translate(this.configClient.createSinkCallable().futureCall(request), new StatusCode.Code[0]);
    }

    @Override
    public ApiFuture<LogSink> update(UpdateSinkRequest request) {
        return GrpcLoggingRpc.translate(this.configClient.updateSinkCallable().futureCall(request), new StatusCode.Code[0]);
    }

    @Override
    public ApiFuture<LogSink> get(GetSinkRequest request) {
        return GrpcLoggingRpc.translate(this.configClient.getSinkCallable().futureCall(request), StatusCode.Code.NOT_FOUND);
    }

    @Override
    public ApiFuture<ListSinksResponse> list(ListSinksRequest request) {
        return GrpcLoggingRpc.translate(this.configClient.listSinksCallable().futureCall(request), new StatusCode.Code[0]);
    }

    @Override
    public ApiFuture<Empty> delete(DeleteSinkRequest request) {
        return GrpcLoggingRpc.translate(this.configClient.deleteSinkCallable().futureCall(request), StatusCode.Code.NOT_FOUND);
    }

    @Override
    public ApiFuture<LogExclusion> create(CreateExclusionRequest request) {
        return GrpcLoggingRpc.translate(this.configClient.createExclusionCallable().futureCall(request), new StatusCode.Code[0]);
    }

    @Override
    public ApiFuture<LogExclusion> get(GetExclusionRequest request) {
        return GrpcLoggingRpc.translate(this.configClient.getExclusionCallable().futureCall(request), StatusCode.Code.NOT_FOUND);
    }

    @Override
    public ApiFuture<LogExclusion> update(UpdateExclusionRequest request) {
        return GrpcLoggingRpc.translate(this.configClient.updateExclusionCallable().futureCall(request), new StatusCode.Code[0]);
    }

    @Override
    public ApiFuture<ListExclusionsResponse> list(ListExclusionsRequest request) {
        return GrpcLoggingRpc.translate(this.configClient.listExclusionsCallable().futureCall(request), new StatusCode.Code[0]);
    }

    @Override
    public ApiFuture<Empty> delete(DeleteExclusionRequest request) {
        return GrpcLoggingRpc.translate(this.configClient.deleteExclusionCallable().futureCall(request), StatusCode.Code.NOT_FOUND);
    }

    @Override
    public ApiFuture<ListLogsResponse> listLogs(ListLogsRequest request) {
        return GrpcLoggingRpc.translate(this.loggingClient.listLogsCallable().futureCall(request), new StatusCode.Code[0]);
    }

    @Override
    public ApiFuture<Empty> delete(DeleteLogRequest request) {
        return GrpcLoggingRpc.translate(this.loggingClient.deleteLogCallable().futureCall(request), StatusCode.Code.NOT_FOUND);
    }

    @Override
    public ApiFuture<WriteLogEntriesResponse> write(WriteLogEntriesRequest request) {
        return GrpcLoggingRpc.translate(this.loggingClient.writeLogEntriesCallable().futureCall(request), new StatusCode.Code[0]);
    }

    @Override
    public ApiFuture<ListLogEntriesResponse> list(ListLogEntriesRequest request) {
        return GrpcLoggingRpc.translate(this.loggingClient.listLogEntriesCallable().futureCall(request), new StatusCode.Code[0]);
    }

    @Override
    public BidiStream<TailLogEntriesRequest, TailLogEntriesResponse> getTailLogEntriesStream() {
        return this.loggingClient.tailLogEntriesCallable().call();
    }

    @Override
    public ApiFuture<ListMonitoredResourceDescriptorsResponse> list(ListMonitoredResourceDescriptorsRequest request) {
        return GrpcLoggingRpc.translate(this.loggingClient.listMonitoredResourceDescriptorsCallable().futureCall(request), new StatusCode.Code[0]);
    }

    @Override
    public ApiFuture<LogMetric> create(CreateLogMetricRequest request) {
        return GrpcLoggingRpc.translate(this.metricsClient.createLogMetricCallable().futureCall(request), new StatusCode.Code[0]);
    }

    @Override
    public ApiFuture<LogMetric> update(UpdateLogMetricRequest request) {
        return GrpcLoggingRpc.translate(this.metricsClient.updateLogMetricCallable().futureCall(request), new StatusCode.Code[0]);
    }

    @Override
    public ApiFuture<LogMetric> get(GetLogMetricRequest request) {
        return GrpcLoggingRpc.translate(this.metricsClient.getLogMetricCallable().futureCall(request), StatusCode.Code.NOT_FOUND);
    }

    @Override
    public ApiFuture<ListLogMetricsResponse> list(ListLogMetricsRequest request) {
        return GrpcLoggingRpc.translate(this.metricsClient.listLogMetricsCallable().futureCall(request), new StatusCode.Code[0]);
    }

    @Override
    public ApiFuture<Empty> delete(DeleteLogMetricRequest request) {
        return GrpcLoggingRpc.translate(this.metricsClient.deleteLogMetricCallable().futureCall(request), StatusCode.Code.NOT_FOUND);
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.configClient.close();
        this.loggingClient.close();
        this.metricsClient.close();
        for (BackgroundResource resource : this.clientContext.getBackgroundResources()) {
            resource.close();
        }
        this.executorFactory.release(this.executor);
    }

    private static class LoggingSettingsBuilder
    extends LoggingSettings.Builder {
        private LoggingSettingsBuilder(LoggingSettings settings) {
            super(settings);
        }

        @Override
        protected LoggingSettings.Builder setInternalHeaderProvider(HeaderProvider internalHeaderProvider) {
            return (LoggingSettings.Builder)super.setInternalHeaderProvider(internalHeaderProvider);
        }
    }
}

