/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.GcsRequestExecutionEvent;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.GoogleCloudStorageEventBus;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.CallOptions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Channel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientCall;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ForwardingClientCall;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ForwardingClientCallListener;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Metadata;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.MethodDescriptor;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;

@VisibleForTesting
public class GoogleCloudStorageClientGrpcStatisticsInterceptor
implements ClientInterceptor {
    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            @Override
            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                try {
                    GoogleCloudStorageEventBus.onGcsRequest(new GcsRequestExecutionEvent());
                }
                catch (Throwable throwable) {
                    super.start(new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        @Override
                        public void onClose(Status status, Metadata trailers) {
                            try {
                                GoogleCloudStorageEventBus.onGrpcStatus(status);
                            }
                            finally {
                                super.onClose(status, trailers);
                            }
                        }
                    }, headers);
                    throw throwable;
                }
                super.start(new /* invalid duplicate definition of identical inner class */, headers);
            }
        };
    }
}

