/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Deadline;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Internal;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.LoadBalancer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.LoadBalancerProvider;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.NameResolver;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.JsonUtil;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.WeightedRoundRobinLoadBalancer;
import java.util.Map;

@Internal
public final class WeightedRoundRobinLoadBalancerProvider
extends LoadBalancerProvider {
    @VisibleForTesting
    static final long MIN_WEIGHT_UPDATE_PERIOD_NANOS = 100000000L;
    static final String SCHEME = "weighted_round_robin";

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new WeightedRoundRobinLoadBalancer(helper, Deadline.getSystemTicker());
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public String getPolicyName() {
        return SCHEME;
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawConfig) {
        try {
            return this.parseLoadBalancingPolicyConfigInternal(rawConfig);
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError(Status.UNAVAILABLE.withCause(e).withDescription("Failed parsing configuration for " + this.getPolicyName()));
        }
    }

    private NameResolver.ConfigOrError parseLoadBalancingPolicyConfigInternal(Map<String, ?> rawConfig) {
        Long blackoutPeriodNanos = JsonUtil.getStringAsDuration(rawConfig, "blackoutPeriod");
        Long weightExpirationPeriodNanos = JsonUtil.getStringAsDuration(rawConfig, "weightExpirationPeriod");
        Long oobReportingPeriodNanos = JsonUtil.getStringAsDuration(rawConfig, "oobReportingPeriod");
        Boolean enableOobLoadReport = JsonUtil.getBoolean(rawConfig, "enableOobLoadReport");
        Long weightUpdatePeriodNanos = JsonUtil.getStringAsDuration(rawConfig, "weightUpdatePeriod");
        Float errorUtilizationPenalty = JsonUtil.getNumberAsFloat(rawConfig, "errorUtilizationPenalty");
        WeightedRoundRobinLoadBalancer.WeightedRoundRobinLoadBalancerConfig.Builder configBuilder = WeightedRoundRobinLoadBalancer.WeightedRoundRobinLoadBalancerConfig.newBuilder();
        if (blackoutPeriodNanos != null) {
            configBuilder.setBlackoutPeriodNanos(blackoutPeriodNanos);
        }
        if (weightExpirationPeriodNanos != null) {
            configBuilder.setWeightExpirationPeriodNanos(weightExpirationPeriodNanos);
        }
        if (enableOobLoadReport != null) {
            configBuilder.setEnableOobLoadReport(enableOobLoadReport);
        }
        if (oobReportingPeriodNanos != null) {
            configBuilder.setOobReportingPeriodNanos(oobReportingPeriodNanos);
        }
        if (weightUpdatePeriodNanos != null) {
            configBuilder.setWeightUpdatePeriodNanos(weightUpdatePeriodNanos);
            if (weightUpdatePeriodNanos < 100000000L) {
                configBuilder.setWeightUpdatePeriodNanos(100000000L);
            }
        }
        if (errorUtilizationPenalty != null) {
            configBuilder.setErrorUtilizationPenalty(errorUtilizationPenalty.floatValue());
        }
        return NameResolver.ConfigOrError.fromConfig(configBuilder.build());
    }
}

