/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics;

import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.common.Attributes;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.metrics.LongHistogram;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.metrics.LongHistogramBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.context.Context;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.internal.ThrottlingLogger;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.AbstractInstrument;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.InstrumentBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.InstrumentType;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.InstrumentValueType;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.SdkMeter;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.internal.aggregator.ExplicitBucketHistogramUtils;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.internal.descriptor.Advice;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

class SdkLongHistogram
extends AbstractInstrument
implements LongHistogram {
    private static final Logger logger = Logger.getLogger(SdkLongHistogram.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    final SdkMeter sdkMeter;
    final WriteableMetricStorage storage;

    SdkLongHistogram(InstrumentDescriptor descriptor, SdkMeter sdkMeter, WriteableMetricStorage storage) {
        super(descriptor);
        this.sdkMeter = sdkMeter;
        this.storage = storage;
    }

    @Override
    public void record(long value, Attributes attributes, Context context) {
        if (value < 0L) {
            this.throttlingLogger.log(Level.WARNING, "Histograms can only record non-negative values. Instrument " + this.getDescriptor().getName() + " has recorded a negative value.");
            return;
        }
        this.storage.recordLong(value, attributes, context);
    }

    @Override
    public void record(long value, Attributes attributes) {
        this.record(value, attributes, Context.current());
    }

    @Override
    public void record(long value) {
        this.record(value, Attributes.empty());
    }

    static class SdkLongHistogramBuilder
    implements LongHistogramBuilder {
        final InstrumentBuilder builder;

        SdkLongHistogramBuilder(SdkMeter sdkMeter, String name, String description, String unit, Advice.AdviceBuilder adviceBuilder) {
            this.builder = new InstrumentBuilder(name, InstrumentType.HISTOGRAM, InstrumentValueType.LONG, sdkMeter).setDescription(description).setUnit(unit).setAdviceBuilder(adviceBuilder);
        }

        @Override
        public LongHistogramBuilder setDescription(String description) {
            this.builder.setDescription(description);
            return this;
        }

        @Override
        public LongHistogramBuilder setUnit(String unit) {
            this.builder.setUnit(unit);
            return this;
        }

        @Override
        public SdkLongHistogram build() {
            return this.builder.buildSynchronousInstrument(SdkLongHistogram::new);
        }

        @Override
        public LongHistogramBuilder setExplicitBucketBoundariesAdvice(List<Long> bucketBoundaries) {
            List<Double> boundaries;
            try {
                Objects.requireNonNull(bucketBoundaries, "bucketBoundaries must not be null");
                boundaries = bucketBoundaries.stream().map(Long::doubleValue).collect(Collectors.toList());
                ExplicitBucketHistogramUtils.validateBucketBoundaries(boundaries);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                logger.warning("Error setting explicit bucket boundaries advice: " + e.getMessage());
                return this;
            }
            this.builder.setExplicitBucketBoundaries(boundaries);
            return this;
        }

        public String toString() {
            return this.builder.toStringHelper(this.getClass().getSimpleName());
        }
    }
}

