/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.trace.data;

import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.trace.StatusCode;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.trace.data.AutoValue_ImmutableStatusData;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.trace.data.StatusData;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
abstract class ImmutableStatusData
implements StatusData {
    static final StatusData OK = ImmutableStatusData.createInternal(StatusCode.OK, "");
    static final StatusData UNSET = ImmutableStatusData.createInternal(StatusCode.UNSET, "");
    static final StatusData ERROR = ImmutableStatusData.createInternal(StatusCode.ERROR, "");

    ImmutableStatusData() {
    }

    static StatusData create(StatusCode statusCode, String description) {
        if (description == null || description.isEmpty()) {
            switch (statusCode) {
                case UNSET: {
                    return StatusData.unset();
                }
                case OK: {
                    return StatusData.ok();
                }
                case ERROR: {
                    return StatusData.error();
                }
            }
        }
        return ImmutableStatusData.createInternal(statusCode, description);
    }

    private static StatusData createInternal(StatusCode statusCode, String description) {
        return new AutoValue_ImmutableStatusData(statusCode, description);
    }
}

