/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;

@VisibleForTesting
class FileAccessPatternManager {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final StorageResourceId resourceId;
    private final GoogleCloudStorageReadOptions readOptions;
    private boolean isPatternOverriden = false;
    private boolean randomAccess;
    private boolean isBackwardSeekRequested = false;
    private boolean isForwardSeekRequested = false;
    private long lastServedIndex = -1L;
    private int consecutiveSequentialCount = 0;

    public FileAccessPatternManager(StorageResourceId resourceId, GoogleCloudStorageReadOptions readOptions) {
        this.resourceId = resourceId;
        this.readOptions = readOptions;
        this.randomAccess = readOptions.getFadvise() == GoogleCloudStorageReadOptions.Fadvise.AUTO_RANDOM || readOptions.getFadvise() == GoogleCloudStorageReadOptions.Fadvise.RANDOM;
    }

    public void updateLastServedIndex(long position) {
        this.lastServedIndex = position;
    }

    public boolean shouldAdaptToRandomAccess() {
        return this.randomAccess;
    }

    public void updateAccessPattern(long currentPosition) {
        if (this.isPatternOverriden) {
            ((GoogleLogger.Api)logger.atFinest()).log("Will bypass computing access pattern as it's overriden for resource :%s", this.resourceId);
            return;
        }
        this.updateSeekFlags(currentPosition);
        if (this.readOptions.getFadvise() == GoogleCloudStorageReadOptions.Fadvise.AUTO_RANDOM) {
            if (this.randomAccess) {
                if (this.shouldAdaptToSequential(currentPosition)) {
                    this.unsetRandomAccess();
                }
            } else if (this.shouldAdaptToRandomAccess(currentPosition)) {
                this.setRandomAccess();
            }
        } else if (this.readOptions.getFadvise() == GoogleCloudStorageReadOptions.Fadvise.AUTO && this.shouldAdaptToRandomAccess(currentPosition)) {
            this.setRandomAccess();
        }
    }

    public void overrideAccessPattern(boolean isRandomPattern) {
        this.isPatternOverriden = true;
        this.randomAccess = isRandomPattern;
        ((GoogleLogger.Api)logger.atFinest()).log("Overriding the random access pattern to %s for fadvise:%s for resource: %s ", isRandomPattern, (Object)this.readOptions.getFadvise(), this.resourceId);
    }

    private boolean shouldAdaptToSequential(long currentPosition) {
        if (this.lastServedIndex != -1L) {
            long distance = currentPosition - this.lastServedIndex;
            this.consecutiveSequentialCount = distance < 0L || distance > this.readOptions.getInplaceSeekLimit() ? 0 : ++this.consecutiveSequentialCount;
        }
        if (!this.shouldDetectSequentialAccess()) {
            return false;
        }
        if (this.consecutiveSequentialCount < this.readOptions.getFadviseRequestTrackCount()) {
            return false;
        }
        ((GoogleLogger.Api)logger.atFinest()).log("Detected %d consecutive read request within distance threshold %d with fadvise: %s switching to sequential IO for '%s'", this.consecutiveSequentialCount, this.readOptions.getInplaceSeekLimit(), (Object)this.readOptions.getFadvise(), this.resourceId);
        return true;
    }

    private boolean shouldAdaptToRandomAccess(long currentPosition) {
        if (!this.shouldDetectRandomAccess()) {
            return false;
        }
        if (this.lastServedIndex == -1L) {
            return false;
        }
        if (this.isBackwardOrForwardSeekRequested()) {
            ((GoogleLogger.Api)logger.atFinest()).log("Backward or forward seek requested, isBackwardSeek: %s, isForwardSeek:%s for '%s'", this.isBackwardSeekRequested, this.isForwardSeekRequested, this.resourceId);
            return true;
        }
        return false;
    }

    private boolean shouldDetectSequentialAccess() {
        return this.randomAccess && !this.isBackwardOrForwardSeekRequested() && this.consecutiveSequentialCount >= this.readOptions.getFadviseRequestTrackCount() && this.readOptions.getFadvise() == GoogleCloudStorageReadOptions.Fadvise.AUTO_RANDOM;
    }

    private boolean shouldDetectRandomAccess() {
        return !this.randomAccess && (this.readOptions.getFadvise() == GoogleCloudStorageReadOptions.Fadvise.AUTO || this.readOptions.getFadvise() == GoogleCloudStorageReadOptions.Fadvise.AUTO_RANDOM);
    }

    private void setRandomAccess() {
        this.randomAccess = true;
    }

    private void unsetRandomAccess() {
        this.randomAccess = false;
    }

    private boolean isBackwardOrForwardSeekRequested() {
        return this.isBackwardSeekRequested || this.isForwardSeekRequested;
    }

    private void updateSeekFlags(long currentPosition) {
        if (this.lastServedIndex == -1L) {
            return;
        }
        if (currentPosition < this.lastServedIndex) {
            this.isBackwardSeekRequested = true;
            ((GoogleLogger.Api)logger.atFinest()).log("Detected backward read from %s to %s position, updating to backwardSeek for '%s'", this.lastServedIndex, currentPosition, this.resourceId);
        } else if (this.lastServedIndex + this.readOptions.getInplaceSeekLimit() < currentPosition) {
            this.isForwardSeekRequested = true;
            ((GoogleLogger.Api)logger.atFinest()).log("Detected forward read from %s to %s position over %s threshold, updated to forwardSeek for '%s'", this.lastServedIndex, currentPosition, this.readOptions.getInplaceSeekLimit(), this.resourceId);
        }
    }
}

