/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.Credentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateFileOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.FileInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.FolderInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientImpl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.ListFileOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.ListFolderOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.ListObjectOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.PerformanceCachingGoogleCloudStorage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StringPaths;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.UriPaths;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.CheckedFunction;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.GoogleCloudStorageEventBus;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ITraceOperation;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.LazyExecutorService;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ThreadTrace;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.TraceOperation;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Strings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.Iterables;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.Futures;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.ListenableFuture;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.ListeningExecutorService;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.MoreExecutors;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.cloud.hadoop.util.AccessBoundary;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GoogleCloudStorageFileSystemImpl
implements GoogleCloudStorageFileSystem {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final ThreadFactory DAEMON_THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("gcsfs-thread-%d").setDaemon(true).build();
    private static final ListObjectOptions GET_FILE_INFO_LIST_OPTIONS = ListObjectOptions.DEFAULT.toBuilder().setIncludePrefix(true).setMaxResults(1L).build();
    private static final ListObjectOptions LIST_OPTIONS_INCLUDE_FOLDERS = ListObjectOptions.DEFAULT.toBuilder().setIncludePrefix(true).setIncludeFoldersAsPrefixes(true).build();
    private static final ListObjectOptions DIRECTORY_EMPTINESS_CHECK_OPTIONS = ListObjectOptions.DEFAULT.toBuilder().setIncludeFoldersAsPrefixes(true).setMaxResults(1L).build();
    private static final ListObjectOptions LIST_FILE_INFO_LIST_OPTIONS = ListObjectOptions.DEFAULT.toBuilder().setIncludePrefix(true).build();
    public static final ListFileOptions DELETE_RENAME_LIST_OPTIONS = ListFileOptions.DEFAULT.toBuilder().setFields("bucket,name,generation").build();
    private GoogleCloudStorage gcs;
    private final GoogleCloudStorageFileSystemOptions options;
    private ExecutorService cachedExecutor = GoogleCloudStorageFileSystemImpl.createCachedExecutor();
    private ExecutorService lazyExecutor = new LazyExecutorService();
    @VisibleForTesting
    static final Comparator<URI> PATH_COMPARATOR = Comparator.comparing(URI::toString, (as, bs) -> as.length() == bs.length() ? as.compareTo((String)bs) : Integer.compare(as.length(), bs.length()));
    @VisibleForTesting
    static final Comparator<FileInfo> FILE_INFO_PATH_COMPARATOR = Comparator.comparing(FileInfo::getPath, PATH_COMPARATOR);

    private static GoogleCloudStorage createCloudStorage(GoogleCloudStorageFileSystemOptions options, Credentials credentials, Function<List<AccessBoundary>, String> downscopedAccessTokenFn) throws IOException {
        Preconditions.checkNotNull(options, "options must not be null");
        switch (options.getClientType()) {
            case STORAGE_CLIENT: {
                return GoogleCloudStorageClientImpl.builder().setOptions(options.getCloudStorageOptions()).setCredentials(credentials).setDownscopedAccessTokenFn(downscopedAccessTokenFn).build();
            }
        }
        return GoogleCloudStorageImpl.builder().setOptions(options.getCloudStorageOptions()).setCredentials(credentials).setDownscopedAccessTokenFn(downscopedAccessTokenFn).build();
    }

    public GoogleCloudStorageFileSystemImpl(Credentials credentials, GoogleCloudStorageFileSystemOptions options) throws IOException {
        this(GoogleCloudStorageFileSystemImpl.createCloudStorage(options, credentials, null), options);
        ((GoogleLogger.Api)logger.atFiner()).log("GoogleCloudStorageFileSystem(options: %s)", options);
    }

    public GoogleCloudStorageFileSystemImpl(Credentials credentials, Function<List<AccessBoundary>, String> downscopedAccessTokenFn, GoogleCloudStorageFileSystemOptions options) throws IOException {
        this(GoogleCloudStorageFileSystemImpl.createCloudStorage(options, credentials, downscopedAccessTokenFn), options);
        ((GoogleLogger.Api)logger.atFiner()).log("GoogleCloudStorageFileSystem(options: %s)", options);
    }

    @VisibleForTesting
    public GoogleCloudStorageFileSystemImpl(CheckedFunction<GoogleCloudStorageOptions, GoogleCloudStorage, IOException> gcsFn, GoogleCloudStorageFileSystemOptions options) throws IOException {
        this(gcsFn.apply(options.getCloudStorageOptions()), options);
    }

    @VisibleForTesting
    public GoogleCloudStorageFileSystemImpl(GoogleCloudStorage gcs, GoogleCloudStorageFileSystemOptions options) {
        Preconditions.checkArgument(gcs.getOptions() == options.getCloudStorageOptions(), "gcs and gcsfs should use the same options");
        options.throwIfNotValid();
        this.gcs = options.isPerformanceCacheEnabled() ? new PerformanceCachingGoogleCloudStorage(gcs, options.getPerformanceCacheOptions()) : gcs;
        this.options = options;
    }

    private static ExecutorService createCachedExecutor() {
        ThreadPoolExecutor service = new ThreadPoolExecutor(2, Integer.MAX_VALUE, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("gcsfs-misc-%d").setDaemon(true).build());
        service.allowCoreThreadTimeOut(true);
        return service;
    }

    @Override
    public GoogleCloudStorageFileSystemOptions getOptions() {
        return this.options;
    }

    public static CreateObjectOptions objectOptionsFromFileOptions(CreateFileOptions options) {
        Preconditions.checkArgument(options.getWriteMode() == CreateFileOptions.WriteMode.CREATE_NEW || options.getWriteMode() == CreateFileOptions.WriteMode.OVERWRITE, "unsupported write mode: %s", (Object)options.getWriteMode());
        return CreateObjectOptions.builder().setContentType(options.getContentType()).setMetadata(options.getAttributes()).setOverwriteExisting(options.getWriteMode() == CreateFileOptions.WriteMode.OVERWRITE).build();
    }

    @Override
    public WritableByteChannel create(URI path, CreateFileOptions createOptions) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("create(path: %s, createOptions: %s)", (Object)path, (Object)createOptions);
        Preconditions.checkNotNull(path, "path could not be null");
        StorageResourceId resourceId = StorageResourceId.fromUriPath(path, true);
        if (resourceId.isDirectory()) {
            GoogleCloudStorageEventBus.postOnException();
            throw new IOException(String.format("Cannot create a file whose name looks like a directory: '%s'", resourceId));
        }
        if (this.options.isEnsureNoConflictingItems()) {
            StorageResourceId dirId = resourceId.toDirectoryId();
            ListenableFuture<Boolean> conflictingDirExist = createOptions.isEnsureNoDirectoryConflict() ? this.cachedExecutor.submit(() -> this.getFileInfoInternal(dirId, true).exists()) : Futures.immediateFuture(false);
            this.checkNoFilesConflictingWithDirs(resourceId);
            if (GoogleCloudStorageFileSystemImpl.getFromFuture(conflictingDirExist).booleanValue()) {
                GoogleCloudStorageEventBus.postOnException();
                throw new FileAlreadyExistsException("A directory with that name exists: " + String.valueOf(path));
            }
        }
        if (createOptions.getOverwriteGenerationId() != -1L) {
            resourceId = new StorageResourceId(resourceId.getBucketName(), resourceId.getObjectName(), createOptions.getOverwriteGenerationId());
        }
        return this.gcs.create(resourceId, GoogleCloudStorageFileSystemImpl.objectOptionsFromFileOptions(createOptions));
    }

    @Override
    public SeekableByteChannel open(URI path, GoogleCloudStorageReadOptions readOptions) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("open(path: %s, readOptions: %s)", (Object)path, (Object)readOptions);
        Preconditions.checkNotNull(path, "path should not be null");
        StorageResourceId resourceId = StorageResourceId.fromUriPath(path, false);
        Preconditions.checkArgument(!resourceId.isDirectory(), "Cannot open a directory for reading: %s", (Object)path);
        return this.gcs.open(resourceId, readOptions);
    }

    @Override
    public SeekableByteChannel open(FileInfo fileInfo, GoogleCloudStorageReadOptions readOptions) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("open(fileInfo : %s, readOptions: %s)", (Object)fileInfo, (Object)readOptions);
        Preconditions.checkNotNull(fileInfo, "fileInfo should not be null");
        Preconditions.checkArgument(!fileInfo.isDirectory(), "Cannot open a directory for reading: %s", (Object)fileInfo.getPath());
        return this.gcs.open(fileInfo.getItemInfo(), readOptions);
    }

    @Override
    public void delete(URI path, boolean recursive) throws IOException {
        List<Object> itemsToDelete;
        Preconditions.checkNotNull(path, "path should not be null");
        Preconditions.checkArgument(!path.equals(GCS_ROOT), "Cannot delete root path (%s)", (Object)path);
        ((GoogleLogger.Api)logger.atFiner()).log("delete(path: %s, recursive: %b)", (Object)path, recursive);
        FileInfo fileInfo = this.getFileInfo(path);
        if (!fileInfo.exists()) {
            GoogleCloudStorageEventBus.postOnException();
            throw new FileNotFoundException("Item not found: " + String.valueOf(path));
        }
        Future<GoogleCloudStorageItemInfo> parentInfoFuture = null;
        if (this.options.getCloudStorageOptions().isAutoRepairImplicitDirectoriesEnabled()) {
            StorageResourceId parentId = StorageResourceId.fromUriPath(UriPaths.getParentPath(path), true);
            parentInfoFuture = this.cachedExecutor.submit(() -> this.getFileInfoInternal(parentId, false));
        }
        boolean isHnBucket = this.options.getCloudStorageOptions().isHnBucketRenameEnabled() && this.gcs.isHnBucket(path);
        List<FolderInfo> listOfFolders = new LinkedList<FolderInfo>();
        if (fileInfo.isDirectory()) {
            itemsToDelete = this.getItemsToDelete(fileInfo, recursive);
            if (isHnBucket) {
                String bucketName = this.getBucketName(path);
                String folderName = this.getFolderName(path);
                listOfFolders = recursive ? this.listFoldersInfoForPrefixPage(fileInfo.getPath(), ListFolderOptions.DEFAULT, null).getItems() : (folderName.equals("") ? new LinkedList() : Arrays.asList(new FolderInfo(FolderInfo.createFolderInfoObject(bucketName, folderName))));
                ((GoogleLogger.Api)logger.atFiner()).log("Encountered HN enabled bucket with %s number of folder in path : %s", listOfFolders.size(), (Object)path);
            }
            if (!itemsToDelete.isEmpty() && !recursive) {
                GoogleCloudStorageEventBus.postOnException();
                throw new DirectoryNotEmptyException("Cannot delete a non-empty directory.");
            }
        } else {
            itemsToDelete = new ArrayList();
        }
        ArrayList<FileInfo> bucketsToDelete = new ArrayList<FileInfo>();
        (fileInfo.getItemInfo().isBucket() ? bucketsToDelete : itemsToDelete).add(fileInfo);
        this.deleteInternalWithFolders(itemsToDelete, listOfFolders, bucketsToDelete);
        if (!this.isHnsOptimized(path)) {
            this.repairImplicitDirectory(parentInfoFuture);
        }
    }

    private List<FileInfo> getItemsToDelete(FileInfo fileInfo, boolean recursive) throws IOException {
        if (recursive) {
            return this.listFileInfoForPrefix(fileInfo.getPath(), DELETE_RENAME_LIST_OPTIONS);
        }
        if (this.options.getCloudStorageOptions().isHnOptimizationEnabled()) {
            return FileInfo.fromItemInfos(this.gcs.listObjectInfo(fileInfo.getItemInfo().getBucketName(), fileInfo.getItemInfo().getObjectName(), GoogleCloudStorageFileSystemImpl.updateListObjectOptions(DIRECTORY_EMPTINESS_CHECK_OPTIONS, DELETE_RENAME_LIST_OPTIONS)));
        }
        return this.listFileInfoForPrefixPage(fileInfo.getPath(), DELETE_RENAME_LIST_OPTIONS, null).getItems();
    }

    private String getBucketName(@Nonnull URI path) {
        Preconditions.checkState(!Strings.isNullOrEmpty(path.getAuthority()), "Bucket name cannot be null : %s", (Object)path);
        return path.getAuthority();
    }

    private String getFolderName(@Nonnull URI path) {
        Preconditions.checkState(path.getPath().startsWith("/"), "Invalid folder name: %s", (Object)path.getPath());
        return path.getPath().substring(1);
    }

    @Override
    public GoogleCloudStorage.ListPage<FolderInfo> listFoldersInfoForPrefixPage(URI prefix, ListFolderOptions listFolderOptions, String pageToken) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("listFoldersInfoForPrefixPage(prefix: %s, pageToken:%s)", (Object)prefix, (Object)pageToken);
        StorageResourceId prefixId = this.getPrefixId(prefix);
        return this.gcs.listFolderInfoForPrefixPage(prefixId.getBucketName(), prefixId.getObjectName(), listFolderOptions, pageToken);
    }

    private void deleteFolders(@Nonnull List<FolderInfo> listOfFolders) throws IOException {
        if (listOfFolders.isEmpty()) {
            return;
        }
        ((GoogleLogger.Api)logger.atFiner()).log("deleteFolder(listOfFolders: %s, size:%s)", (Object)listOfFolders, listOfFolders.size());
        this.gcs.deleteFolders(listOfFolders);
    }

    private void deleteInternal(List<FileInfo> itemsToDelete, List<FileInfo> bucketsToDelete) throws IOException {
        this.deleteObjects(itemsToDelete);
        this.deleteBucket(bucketsToDelete);
    }

    private void deleteInternalWithFolders(List<FileInfo> itemsToDelete, List<FolderInfo> listOfFolders, List<FileInfo> bucketsToDelete) throws IOException {
        this.deleteObjects(itemsToDelete);
        this.deleteFolders(listOfFolders);
        this.deleteBucket(bucketsToDelete);
    }

    private void deleteObjects(List<FileInfo> itemsToDelete) throws IOException {
        itemsToDelete.sort(FILE_INFO_PATH_COMPARATOR.reversed());
        if (!itemsToDelete.isEmpty()) {
            ArrayList<StorageResourceId> objectsToDelete = new ArrayList<StorageResourceId>(itemsToDelete.size());
            for (FileInfo fileInfo : itemsToDelete) {
                if (fileInfo.isInferredDirectory()) continue;
                objectsToDelete.add(new StorageResourceId(fileInfo.getItemInfo().getBucketName(), fileInfo.getItemInfo().getObjectName(), fileInfo.getItemInfo().getContentGeneration() > 0L ? fileInfo.getItemInfo().getContentGeneration() : -1L));
            }
            this.gcs.deleteObjects(objectsToDelete);
        }
    }

    private void deleteBucket(List<FileInfo> bucketsToDelete) throws IOException {
        if (!bucketsToDelete.isEmpty()) {
            ArrayList<String> bucketNames = new ArrayList<String>(bucketsToDelete.size());
            for (FileInfo bucketInfo : bucketsToDelete) {
                bucketNames.add(bucketInfo.getItemInfo().getResourceId().getBucketName());
            }
            if (this.options.isBucketDeleteEnabled()) {
                this.gcs.deleteBuckets(bucketNames);
            } else {
                ((GoogleLogger.Api)logger.atInfo()).log("Skipping deletion of buckets because enableBucketDelete is false: %s", bucketNames);
            }
        }
    }

    @Override
    public boolean exists(URI path) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("exists(path: %s)", path);
        return this.getFileInfo(path).exists();
    }

    @Override
    public void mkdirs(URI path) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("mkdirs(path: %s)", path);
        Preconditions.checkNotNull(path, "path should not be null");
        this.mkdirsInternal(path);
    }

    private void mkdirsInternal(URI path) throws IOException {
        StorageResourceId resourceId = StorageResourceId.fromUriPath(path, true);
        if (resourceId.isRoot()) {
            return;
        }
        if (resourceId.isBucket()) {
            try {
                this.gcs.createBucket(resourceId.getBucketName());
            }
            catch (FileAlreadyExistsException e) {
                GoogleCloudStorageEventBus.postOnException();
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFiner()).withCause(e)).log("mkdirs: %s already exists, ignoring creation failure", resourceId);
            }
            return;
        }
        resourceId = resourceId.toDirectoryId();
        if (this.options.isEnsureNoConflictingItems()) {
            this.checkNoFilesConflictingWithDirs(resourceId);
        }
        boolean isHns = this.isHnsOptimized(path);
        try {
            if (isHns) {
                this.gcs.createFolder(resourceId, true);
            } else {
                this.gcs.createEmptyObject(resourceId);
            }
        }
        catch (FileAlreadyExistsException e) {
            GoogleCloudStorageEventBus.postOnException();
            String logMessage = isHns ? "mkdirs: Folder '%s' already exists, ignoring creation failure" : "mkdirs: %s object already exists, ignoring creation failure";
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFiner()).withCause(e)).log(logMessage, resourceId);
        }
    }

    @Override
    public void rename(URI src, URI dst) throws IOException {
        FileInfo dstParentInfo;
        ((GoogleLogger.Api)logger.atFiner()).log("rename(src: %s, dst: %s)", (Object)src, (Object)dst);
        Preconditions.checkNotNull(src);
        Preconditions.checkNotNull(dst);
        Preconditions.checkArgument(!src.equals(GCS_ROOT), "Root path cannot be renamed.");
        URI dstParent = UriPaths.getParentPath(dst);
        ArrayList<URI> paths = new ArrayList<URI>();
        paths.add(src);
        paths.add(dst);
        if (dstParent != null) {
            paths.add(dstParent);
        }
        List<FileInfo> fileInfos = this.getFileInfos(paths);
        FileInfo srcInfo = fileInfos.get(0);
        FileInfo dstInfo = fileInfos.get(1);
        FileInfo fileInfo = dstParentInfo = dstParent == null ? null : fileInfos.get(2);
        if (!srcInfo.exists()) {
            GoogleCloudStorageEventBus.postOnException();
            throw new FileNotFoundException("Item not found: " + String.valueOf(src));
        }
        src = srcInfo.getPath();
        if (src.equals(dst = this.getDstUri(srcInfo, dstInfo, dstParentInfo))) {
            return;
        }
        Future<GoogleCloudStorageItemInfo> srcParentInfoFuture = null;
        if (this.options.getCloudStorageOptions().isAutoRepairImplicitDirectoriesEnabled()) {
            StorageResourceId srcParentId = StorageResourceId.fromUriPath(UriPaths.getParentPath(src), true);
            srcParentInfoFuture = this.runFuture(this.cachedExecutor, () -> this.getFileInfoInternal(srcParentId, false), "getParentFileInfo");
        }
        if (srcInfo.isDirectory()) {
            this.renameDirectoryInternal(srcInfo, dst);
        } else {
            StorageResourceId srcResourceId = StorageResourceId.fromUriPath(src, true);
            StorageResourceId dstResourceId = StorageResourceId.fromUriPath(dst, true, 0L);
            if (this.options.getCloudStorageOptions().isMoveOperationEnabled() && srcResourceId.getBucketName().equals(dstResourceId.getBucketName())) {
                this.gcs.move(ImmutableMap.of(new StorageResourceId(srcInfo.getItemInfo().getBucketName(), srcInfo.getItemInfo().getObjectName(), srcInfo.getItemInfo().getContentGeneration()), dstResourceId));
            } else {
                this.gcs.copy(ImmutableMap.of(srcResourceId, dstResourceId));
                this.gcs.deleteObjects(ImmutableList.of(new StorageResourceId(srcInfo.getItemInfo().getBucketName(), srcInfo.getItemInfo().getObjectName(), srcInfo.getItemInfo().getContentGeneration())));
            }
        }
        if (!this.isHnsOptimized(src)) {
            this.repairImplicitDirectory(srcParentInfoFuture);
        }
    }

    private URI getDstUri(FileInfo srcInfo, FileInfo dstInfo, @Nullable FileInfo dstParentInfo) throws IOException {
        URI src = srcInfo.getPath();
        URI dst = dstInfo.getPath();
        if (!srcInfo.isDirectory() && dst.equals(GCS_ROOT)) {
            GoogleCloudStorageEventBus.postOnException();
            throw new IOException("A file cannot be created in root.");
        }
        if (dstInfo.exists() && !dstInfo.isDirectory() && (srcInfo.isDirectory() || !dst.equals(src))) {
            GoogleCloudStorageEventBus.postOnException();
            throw new IOException("Cannot overwrite an existing file: " + String.valueOf(dst));
        }
        if (dstParentInfo != null && !dstParentInfo.exists()) {
            GoogleCloudStorageEventBus.postOnException();
            throw new IOException("Cannot rename because path does not exist: " + String.valueOf(dstParentInfo.getPath()));
        }
        String srcItemName = GoogleCloudStorageFileSystemImpl.getItemName(src);
        if (srcInfo.isDirectory()) {
            if (!dstInfo.isDirectory()) {
                dst = UriPaths.toDirectory(dst);
            }
            if (src.equals(dst)) {
                GoogleCloudStorageEventBus.postOnException();
                throw new IOException("Rename dir to self is forbidden");
            }
            URI dstRelativeToSrc = src.relativize(dst);
            if (!dstRelativeToSrc.equals(dst)) {
                GoogleCloudStorageEventBus.postOnException();
                throw new IOException("Rename to subdir is forbidden");
            }
            if (dstInfo.exists()) {
                dst = dst.equals(GCS_ROOT) ? UriPaths.fromStringPathComponents(srcItemName, null, true) : UriPaths.toDirectory(dst.resolve(srcItemName));
            }
        } else if (dstInfo.isDirectory()) {
            if (!dstInfo.exists()) {
                GoogleCloudStorageEventBus.postOnException();
                throw new IOException("Cannot rename because path does not exist: " + String.valueOf(dstInfo.getPath()));
            }
            dst = dst.resolve(srcItemName);
        }
        return dst;
    }

    @Override
    public void compose(List<URI> sources, URI destination, String contentType) throws IOException {
        StorageResourceId destResource = StorageResourceId.fromStringPath(destination.toString());
        List<String> sourceObjects = sources.stream().map(uri -> StorageResourceId.fromStringPath(uri.toString()).getObjectName()).collect(Collectors.toList());
        this.gcs.compose(destResource.getBucketName(), sourceObjects, destResource.getObjectName(), contentType);
    }

    private void renameDirectoryInternal(FileInfo srcInfo, URI dst) throws IOException {
        Preconditions.checkArgument(srcInfo.isDirectory(), "'%s' should be a directory", (Object)srcInfo);
        Preconditions.checkArgument(dst.toString().endsWith("/"), "'%s' should be a directory", (Object)dst);
        URI src = srcInfo.getPath();
        if (this.options.getCloudStorageOptions().isHnBucketRenameEnabled() && this.gcs.isHnBucket(src)) {
            this.gcs.renameHnFolder(src, dst);
            return;
        }
        TreeMap<FileInfo, URI> srcToDstItemNames = new TreeMap<FileInfo, URI>(FILE_INFO_PATH_COMPARATOR);
        TreeMap<FileInfo, URI> srcToDstMarkerItemNames = new TreeMap<FileInfo, URI>(FILE_INFO_PATH_COMPARATOR);
        List<FileInfo> srcItemInfos = this.listFileInfoForPrefix(src, DELETE_RENAME_LIST_OPTIONS);
        Pattern markerFilePattern = this.options.getMarkerFilePattern();
        String prefix = src.toString();
        for (FileInfo srcItemInfo : srcItemInfos) {
            String relativeItemName = srcItemInfo.getPath().toString().substring(prefix.length());
            URI dstItemName = dst.resolve(relativeItemName);
            if (markerFilePattern != null && markerFilePattern.matcher(relativeItemName).matches()) {
                srcToDstMarkerItemNames.put(srcItemInfo, dstItemName);
                continue;
            }
            srcToDstItemNames.put(srcItemInfo, dstItemName);
        }
        StorageResourceId srcResourceId = StorageResourceId.fromUriPath(src, true);
        StorageResourceId dstResourceId = StorageResourceId.fromUriPath(dst, true, 0L);
        if (this.options.getCloudStorageOptions().isMoveOperationEnabled() && srcResourceId.getBucketName().equals(dstResourceId.getBucketName())) {
            this.moveInternal(srcToDstItemNames);
            this.moveInternal(srcToDstMarkerItemNames);
            if (srcInfo.getItemInfo().isBucket()) {
                this.deleteBucket(Collections.singletonList(srcInfo));
            } else {
                this.deleteObjects(Collections.singletonList(srcInfo));
            }
            return;
        }
        this.copyInternal(srcToDstItemNames);
        this.copyInternal(srcToDstMarkerItemNames);
        ArrayList<FileInfo> bucketsToDelete = new ArrayList<FileInfo>(1);
        ArrayList<FileInfo> srcItemsToDelete = new ArrayList<FileInfo>(srcToDstItemNames.size() + 1);
        srcItemsToDelete.addAll(srcToDstItemNames.keySet());
        if (srcInfo.getItemInfo().isBucket()) {
            bucketsToDelete.add(srcInfo);
        } else {
            srcItemsToDelete.add(srcInfo);
        }
        this.deleteInternal(new ArrayList<FileInfo>(srcToDstMarkerItemNames.keySet()), new ArrayList<FileInfo>());
        this.deleteInternal(srcItemsToDelete, bucketsToDelete);
    }

    private void copyInternal(Map<FileInfo, URI> srcToDstItemNames) throws IOException {
        if (srcToDstItemNames.isEmpty()) {
            return;
        }
        String srcBucketName = null;
        String dstBucketName = null;
        ArrayList<String> srcObjectNames = new ArrayList<String>(srcToDstItemNames.size());
        ArrayList<String> dstObjectNames = new ArrayList<String>(srcToDstItemNames.size());
        for (Map.Entry<FileInfo, URI> srcToDstItemName : srcToDstItemNames.entrySet()) {
            StorageResourceId srcResourceId = srcToDstItemName.getKey().getItemInfo().getResourceId();
            srcBucketName = srcResourceId.getBucketName();
            String srcObjectName = srcResourceId.getObjectName();
            srcObjectNames.add(srcObjectName);
            StorageResourceId dstResourceId = StorageResourceId.fromUriPath(srcToDstItemName.getValue(), true);
            dstBucketName = dstResourceId.getBucketName();
            String dstObjectName = dstResourceId.getObjectName();
            dstObjectNames.add(dstObjectName);
        }
        this.gcs.copy(srcBucketName, srcObjectNames, dstBucketName, dstObjectNames);
    }

    private void moveInternal(Map<FileInfo, URI> srcToDstItemNames) throws IOException {
        if (srcToDstItemNames.isEmpty()) {
            return;
        }
        HashMap<StorageResourceId, StorageResourceId> sourceToDestinationObjectsMap = new HashMap<StorageResourceId, StorageResourceId>();
        for (Map.Entry<FileInfo, URI> srcToDstItemName : srcToDstItemNames.entrySet()) {
            StorageResourceId srcResourceId = srcToDstItemName.getKey().getItemInfo().getResourceId();
            StorageResourceId dstResourceId = StorageResourceId.fromUriPath(srcToDstItemName.getValue(), true);
            sourceToDestinationObjectsMap.put(srcResourceId, dstResourceId);
        }
        this.gcs.move(sourceToDestinationObjectsMap);
    }

    private void repairImplicitDirectory(Future<GoogleCloudStorageItemInfo> infoFuture) throws IOException {
        if (infoFuture == null) {
            return;
        }
        Preconditions.checkState(this.options.getCloudStorageOptions().isAutoRepairImplicitDirectoriesEnabled(), "implicit directories auto repair should be enabled");
        GoogleCloudStorageItemInfo info = GoogleCloudStorageFileSystemImpl.getFromFuture(infoFuture);
        StorageResourceId resourceId = info.getResourceId();
        ((GoogleLogger.Api)logger.atFiner()).log("repairImplicitDirectory(resourceId: %s)", resourceId);
        if (info.exists() || resourceId.isRoot() || resourceId.isBucket() || "/".equals(resourceId.getObjectName())) {
            return;
        }
        Preconditions.checkState(resourceId.isDirectory(), "'%s' should be a directory", (Object)resourceId);
        try {
            this.gcs.createEmptyObject(resourceId);
            ((GoogleLogger.Api)logger.atInfo()).log("Successfully repaired '%s' directory.", resourceId);
        }
        catch (IOException e) {
            GoogleCloudStorageEventBus.postOnException();
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("Failed to repair '%s' directory", resourceId);
        }
    }

    static <T> T getFromFuture(Future<T> future) throws IOException {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            GoogleCloudStorageEventBus.postOnException();
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new IOException(String.format("Failed to get result: %s", e instanceof ExecutionException ? e.getCause() : e), e);
        }
    }

    @Override
    public List<FileInfo> listFileInfoForPrefix(URI prefix, ListFileOptions listOptions) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("listAllFileInfoForPrefix(prefix: %s)", prefix);
        StorageResourceId prefixId = this.getPrefixId(prefix);
        List<GoogleCloudStorageItemInfo> itemInfos = this.gcs.listObjectInfo(prefixId.getBucketName(), prefixId.getObjectName(), GoogleCloudStorageFileSystemImpl.updateListObjectOptions(ListObjectOptions.DEFAULT_FLAT_LIST, listOptions));
        List<FileInfo> fileInfos = FileInfo.fromItemInfos(itemInfos);
        fileInfos.sort(FILE_INFO_PATH_COMPARATOR);
        return fileInfos;
    }

    @Override
    public GoogleCloudStorage.ListPage<FileInfo> listFileInfoForPrefixPage(URI prefix, ListFileOptions listOptions, String pageToken) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("listAllFileInfoForPrefixPage(prefix: %s, pageToken:%s)", (Object)prefix, (Object)pageToken);
        StorageResourceId prefixId = this.getPrefixId(prefix);
        GoogleCloudStorage.ListPage<GoogleCloudStorageItemInfo> itemInfosPage = this.gcs.listObjectInfoPage(prefixId.getBucketName(), prefixId.getObjectName(), GoogleCloudStorageFileSystemImpl.updateListObjectOptions(ListObjectOptions.DEFAULT_FLAT_LIST, listOptions), pageToken);
        List<FileInfo> fileInfosPage = FileInfo.fromItemInfos(itemInfosPage.getItems());
        fileInfosPage.sort(FILE_INFO_PATH_COMPARATOR);
        return new GoogleCloudStorage.ListPage<FileInfo>(fileInfosPage, itemInfosPage.getNextPageToken());
    }

    private StorageResourceId getPrefixId(URI prefix) {
        Preconditions.checkNotNull(prefix, "prefix could not be null");
        StorageResourceId prefixId = StorageResourceId.fromUriPath(prefix, true);
        Preconditions.checkArgument(!prefixId.isRoot(), "prefix must not be global root, got '%s'", (Object)prefix);
        return prefixId;
    }

    @Override
    public List<FileInfo> listFileInfo(URI path, ListFileOptions listOptions) throws IOException {
        Preconditions.checkNotNull(path, "path can not be null");
        ((GoogleLogger.Api)logger.atFiner()).log("listFileInfo(path: %s)", path);
        StorageResourceId pathId = StorageResourceId.fromUriPath(path, true);
        StorageResourceId dirId = pathId.toDirectoryId();
        boolean isHnBucket = this.isHnsOptimized(path);
        ExecutorService executor = this.options.isStatusParallelEnabled() ? this.cachedExecutor : this.lazyExecutor;
        Future<List> dirItemInfosFuture = executor.submit(() -> this.listDirectory(dirId, isHnBucket, listOptions));
        if (!pathId.isDirectory()) {
            try {
                GoogleCloudStorageItemInfo pathInfo = this.gcs.getItemInfo(pathId);
                if (pathInfo.exists()) {
                    ArrayList<FileInfo> listedInfo = new ArrayList<FileInfo>();
                    listedInfo.add(FileInfo.fromItemInfo(pathInfo));
                    dirItemInfosFuture.cancel(true);
                    return listedInfo;
                }
            }
            catch (Exception e) {
                GoogleCloudStorageEventBus.postOnException();
                dirItemInfosFuture.cancel(true);
                throw e;
            }
        }
        List dirItemInfos = GoogleCloudStorageFileSystemImpl.getFromFuture(dirItemInfosFuture);
        if (pathId.isStorageObject() && dirItemInfos.isEmpty()) {
            if (this.isHnsOptimized(path) && this.gcs.getFolderInfo(StorageResourceId.fromUriPath(path, true)).exists()) {
                return FileInfo.fromItemInfos(dirItemInfos);
            }
            GoogleCloudStorageEventBus.postOnException();
            throw new FileNotFoundException("Item not found: " + String.valueOf(path));
        }
        if (!dirItemInfos.isEmpty() && Objects.equals(((GoogleCloudStorageItemInfo)dirItemInfos.get(0)).getResourceId(), dirId)) {
            dirItemInfos.remove(0);
        }
        List<FileInfo> fileInfos = FileInfo.fromItemInfos(dirItemInfos);
        fileInfos.sort(FILE_INFO_PATH_COMPARATOR);
        return fileInfos;
    }

    @Override
    public List<FileInfo> listFileInfoStartingFrom(URI startsFrom, ListFileOptions listOptions) throws IOException {
        Preconditions.checkNotNull(startsFrom, "start Offset can't be null");
        ((GoogleLogger.Api)logger.atFiner()).log("listFileInfoStartingFrom(startsFrom: %s)", startsFrom);
        StorageResourceId startOffsetPathId = StorageResourceId.fromUriPath(startsFrom, true);
        Preconditions.checkArgument(!startOffsetPathId.isRoot(), "provided start offset shouldn't be root but an object path %s", (Object)startsFrom);
        List<GoogleCloudStorageItemInfo> itemsInfo = this.gcs.listObjectInfoStartingFrom(startOffsetPathId.getBucketName(), startOffsetPathId.getObjectName(), GoogleCloudStorageFileSystemImpl.updateListObjectOptions(ListObjectOptions.builder().setMaxResults(this.options.getCloudStorageOptions().getMaxListItemsPerCall()).setIncludePrefix(false).setDelimiter(null).build(), listOptions));
        return FileInfo.fromItemInfos(itemsInfo);
    }

    @Override
    public FileInfo getFileInfo(URI path) throws IOException {
        FileInfo fileInfo;
        Preconditions.checkArgument(path != null, "path must not be null");
        StorageResourceId resourceId = StorageResourceId.fromUriPath(path, true);
        if (this.isHnsOptimized(path) && (fileInfo = FileInfo.fromItemInfo(this.gcs.getFolderInfo(resourceId.toDirectoryId()))).exists()) {
            return fileInfo;
        }
        fileInfo = FileInfo.fromItemInfo(this.getFileInfoInternal(resourceId, true));
        ((GoogleLogger.Api)logger.atFiner()).log("getFileInfo(path: %s): %s", (Object)path, (Object)fileInfo);
        return fileInfo;
    }

    @Override
    public FileInfo getFileInfoWithHint(URI path, PathTypeHint pathTypeHint) throws IOException {
        Preconditions.checkArgument(path != null, "path must not be null");
        StorageResourceId resourceId = StorageResourceId.fromUriPath(path, true);
        FileInfo fileInfo = FileInfo.fromItemInfo(this.getFileInfoInternal(resourceId, true, pathTypeHint));
        ((GoogleLogger.Api)logger.atFiner()).log("getFileInfo(path: %s): %s", (Object)path, (Object)fileInfo);
        return fileInfo;
    }

    @Override
    public FileInfo getFileInfoObject(URI path) throws IOException {
        Preconditions.checkArgument(path != null, "path must not be null");
        StorageResourceId resourceId = StorageResourceId.fromUriPath(path, true);
        Preconditions.checkArgument(!resourceId.isDirectory(), String.format("path must be an object and not a directory, path: %s, resourceId: %s", path, resourceId));
        FileInfo fileInfo = FileInfo.fromItemInfo(this.gcs.getItemInfo(resourceId));
        ((GoogleLogger.Api)logger.atFiner()).log("getFileInfoObject(path: %s): %s", (Object)path, (Object)fileInfo);
        return fileInfo;
    }

    private List<GoogleCloudStorageItemInfo> listDirectory(StorageResourceId dirId, boolean isHnBucket, ListFileOptions listOptions) throws IOException {
        if (dirId.isRoot()) {
            return this.gcs.listBucketInfo();
        }
        return this.gcs.listObjectInfo(dirId.getBucketName(), dirId.getObjectName(), GoogleCloudStorageFileSystemImpl.updateListObjectOptions(isHnBucket ? LIST_OPTIONS_INCLUDE_FOLDERS : LIST_FILE_INFO_LIST_OPTIONS, listOptions));
    }

    private GoogleCloudStorageItemInfo getFileInfoInternal(StorageResourceId resourceId, boolean inferImplicitDirectories) throws IOException {
        return this.getFileInfoInternal(resourceId, inferImplicitDirectories, PathTypeHint.NONE);
    }

    private GoogleCloudStorageItemInfo getFileInfoInternal(StorageResourceId resourceId, boolean inferImplicitDirectories, PathTypeHint pathTypeHint) throws IOException {
        List listDirInfo;
        if (resourceId.isRoot() || resourceId.isBucket()) {
            return this.gcs.getItemInfo(resourceId);
        }
        StorageResourceId dirId = resourceId.toDirectoryId();
        Future<List> listDirFuture = (this.options.isStatusParallelEnabled() && pathTypeHint != PathTypeHint.FILE ? this.cachedExecutor : this.lazyExecutor).submit(() -> inferImplicitDirectories ? this.gcs.listObjectInfo(dirId.getBucketName(), dirId.getObjectName(), GET_FILE_INFO_LIST_OPTIONS) : ImmutableList.of(this.gcs.getItemInfo(dirId)));
        if (!resourceId.isDirectory()) {
            try {
                GoogleCloudStorageItemInfo itemInfo = this.gcs.getItemInfo(resourceId);
                if (itemInfo.exists()) {
                    listDirFuture.cancel(true);
                    return itemInfo;
                }
            }
            catch (Exception e) {
                GoogleCloudStorageEventBus.postOnException();
                listDirFuture.cancel(true);
                throw e;
            }
        }
        if ((listDirInfo = GoogleCloudStorageFileSystemImpl.getFromFuture(listDirFuture)).isEmpty()) {
            return GoogleCloudStorageItemInfo.createNotFound(resourceId);
        }
        Preconditions.checkState(listDirInfo.size() <= 2, "listed more than 2 objects: '%s'", (Object)listDirInfo);
        GoogleCloudStorageItemInfo dirInfo = (GoogleCloudStorageItemInfo)Iterables.get(listDirInfo, 0);
        Preconditions.checkState(dirInfo.getResourceId().equals(dirId) || !inferImplicitDirectories, "listed wrong object '%s', but should be '%s'", (Object)dirInfo.getResourceId(), (Object)resourceId);
        return dirInfo.getResourceId().equals(dirId) && dirInfo.exists() ? dirInfo : GoogleCloudStorageItemInfo.createNotFound(resourceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FileInfo> getFileInfos(List<URI> paths) throws IOException {
        Preconditions.checkArgument(paths != null, "paths must not be null");
        ((GoogleLogger.Api)logger.atFiner()).log("getFileInfos(paths: %s)", paths);
        if (paths.size() == 1) {
            return new ArrayList<FileInfo>(Collections.singleton(this.getFileInfo(paths.get(0))));
        }
        int maxThreads = this.gcs.getOptions().getBatchThreads();
        ListeningExecutorService fileInfoExecutor = maxThreads == 0 ? MoreExecutors.newDirectExecutorService() : Executors.newFixedThreadPool(Math.min(maxThreads, paths.size()), DAEMON_THREAD_FACTORY);
        try {
            ArrayList<Future<FileInfo>> infoFutures = new ArrayList<Future<FileInfo>>(paths.size());
            for (URI path : paths) {
                infoFutures.add(this.runFuture(fileInfoExecutor, () -> this.getFileInfo(path), "getFileInfo"));
            }
            fileInfoExecutor.shutdown();
            ArrayList<FileInfo> infos = new ArrayList<FileInfo>(paths.size());
            for (Future future : infoFutures) {
                infos.add((FileInfo)GoogleCloudStorageFileSystemImpl.getFromFuture(future));
            }
            ArrayList<FileInfo> arrayList = infos;
            return arrayList;
        }
        finally {
            fileInfoExecutor.shutdownNow();
        }
    }

    @Override
    public void close() {
        if (this.gcs == null) {
            return;
        }
        ((GoogleLogger.Api)logger.atFiner()).log("close()");
        try {
            this.cachedExecutor.shutdown();
            this.lazyExecutor.shutdown();
            this.gcs.close();
        }
        finally {
            this.cachedExecutor = null;
            this.lazyExecutor = null;
            this.gcs = null;
        }
    }

    @Override
    @VisibleForTesting
    public void mkdir(URI path) throws IOException {
        Preconditions.checkNotNull(path);
        ((GoogleLogger.Api)logger.atFiner()).log("mkdir(path: %s)", path);
        Preconditions.checkArgument(!path.equals(GCS_ROOT), "Cannot create root directory.");
        StorageResourceId resourceId = StorageResourceId.fromUriPath(path, true);
        if (resourceId.isBucket()) {
            this.gcs.createBucket(resourceId.getBucketName());
            return;
        }
        resourceId = resourceId.toDirectoryId();
        if (this.isHnsOptimized(path)) {
            this.gcs.createFolder(resourceId, false);
        } else {
            this.gcs.createEmptyObject(resourceId);
        }
    }

    private void checkNoFilesConflictingWithDirs(StorageResourceId resourceId) throws IOException {
        List fileIds = GoogleCloudStorageFileSystemImpl.getDirs(resourceId.getObjectName()).stream().filter(subdir -> !Strings.isNullOrEmpty(subdir)).map(subdir -> new StorageResourceId(resourceId.getBucketName(), StringPaths.toFilePath(subdir))).collect(ImmutableList.toImmutableList());
        for (GoogleCloudStorageItemInfo fileInfo : this.gcs.getItemInfos(fileIds)) {
            if (!fileInfo.exists()) continue;
            GoogleCloudStorageEventBus.postOnException();
            throw new FileAlreadyExistsException("Cannot create directories because of existing file: " + String.valueOf(fileInfo.getResourceId()));
        }
    }

    private boolean isHnsOptimized(URI path) throws IOException {
        GoogleCloudStorageOptions gcsOptions = this.options.getCloudStorageOptions();
        return gcsOptions.isHnBucketRenameEnabled() && gcsOptions.isHnOptimizationEnabled() && this.gcs.isHnBucket(path);
    }

    private <T> Future<T> runFuture(ExecutorService service, Callable<T> task, String name) {
        ThreadTrace trace = TraceOperation.current();
        return service.submit(() -> {
            try (ITraceOperation traceOperation = TraceOperation.getChildTrace(trace, name);){
                Object v = task.call();
                return v;
            }
        });
    }

    static List<String> getDirs(String objectName) {
        if (Strings.isNullOrEmpty(objectName)) {
            return ImmutableList.of();
        }
        ArrayList<String> dirs = new ArrayList<String>();
        int index = 0;
        while ((index = objectName.indexOf("/", index)) >= 0) {
            dirs.add(objectName.substring(0, index += "/".length()));
        }
        return dirs;
    }

    @Nullable
    static String getItemName(URI path) {
        Preconditions.checkNotNull(path, "path can not be null");
        if (path.equals(GCS_ROOT)) {
            return null;
        }
        StorageResourceId resourceId = StorageResourceId.fromUriPath(path, true);
        if (resourceId.isBucket()) {
            return resourceId.getBucketName();
        }
        String objectName = resourceId.getObjectName();
        int index = StringPaths.isDirectoryPath(objectName) ? objectName.lastIndexOf("/", objectName.length() - 2) : objectName.lastIndexOf("/");
        return index < 0 ? objectName : objectName.substring(index + 1);
    }

    private static ListObjectOptions updateListObjectOptions(ListObjectOptions listObjectOptions, ListFileOptions listFileOptions) {
        return listObjectOptions.toBuilder().setFields(listFileOptions.getFields()).build();
    }

    @Override
    public GoogleCloudStorage getGcs() {
        return this.gcs;
    }

    public static enum PathTypeHint {
        FILE,
        NONE;

    }
}

