/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.interceptors;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpExecuteInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpHeaders;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.InvocationIdContext;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RequestTracker;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ThreadTrace;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.TraceOperation;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import java.io.IOException;

@VisibleForTesting
public final class InvocationIdInterceptor
implements HttpExecuteInterceptor {
    public static final String GCCL_INVOCATION_ID_PREFIX = "gccl-invocation-id/";
    public static final String GOOG_API_CLIENT = "x-goog-api-client";
    private final HttpExecuteInterceptor interceptor;
    private final RequestTracker tracker;

    public InvocationIdInterceptor(HttpExecuteInterceptor interceptor, RequestTracker tracker) {
        this.interceptor = interceptor;
        this.tracker = tracker;
    }

    @Override
    public void intercept(HttpRequest request) throws IOException {
        if (this.interceptor != null) {
            this.interceptor.intercept(request);
        }
        this.tracker.init(request);
        HttpHeaders headers = request.getHeaders();
        String existing = (String)headers.get(GOOG_API_CLIENT);
        if (InvocationIdInterceptor.isInvocationIdPresent(existing)) {
            return;
        }
        String signatureKey = "Signature=";
        String builtURL = request.getUrl().build();
        if (!builtURL.contains("Signature=")) {
            if (InvocationIdContext.getInvocationId().isEmpty()) {
                InvocationIdContext.setInvocationId();
            }
            String invocationEntry = InvocationIdContext.getInvocationId();
            Object newValue = existing != null && !existing.isEmpty() ? existing + " " + invocationEntry : invocationEntry;
            headers.set(GOOG_API_CLIENT, newValue);
            ThreadTrace tt = TraceOperation.current();
            if (tt != null) {
                tt.annotate("invocationId", newValue);
            }
        }
    }

    private static boolean isInvocationIdPresent(String apiClientHeader) {
        return apiClientHeader != null && apiClientHeader.contains(GCCL_INVOCATION_ID_PREFIX);
    }
}

