/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Crc32cValue;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.BidiWriteObjectRequest;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.Nullable;

final class BidiWriteCtx<RequestFactoryT extends BidiWriteObjectRequestBuilderFactory> {
    private final RequestFactoryT requestFactory;
    private final AtomicLong totalSentBytes;
    private final AtomicLong confirmedBytes;
    private final AtomicReference<Crc32cValue.Crc32cLengthKnown> cumulativeCrc32c;

    BidiWriteCtx(RequestFactoryT requestFactory) {
        this.requestFactory = requestFactory;
        this.totalSentBytes = new AtomicLong(0L);
        this.confirmedBytes = new AtomicLong(0L);
        this.cumulativeCrc32c = new AtomicReference();
    }

    public RequestFactoryT getRequestFactory() {
        return this.requestFactory;
    }

    public BidiWriteObjectRequest.Builder newRequestBuilder() {
        return this.requestFactory.newBuilder();
    }

    public AtomicLong getTotalSentBytes() {
        return this.totalSentBytes;
    }

    public AtomicLong getConfirmedBytes() {
        return this.confirmedBytes;
    }

    public AtomicReference<Crc32cValue.Crc32cLengthKnown> getCumulativeCrc32c() {
        return this.cumulativeCrc32c;
    }

    boolean isDirty() {
        return this.confirmedBytes.get() == this.totalSentBytes.get();
    }

    public String toString() {
        return "ServerState{requestFactory=" + this.requestFactory + ", totalSentBytes=" + this.totalSentBytes + ", confirmedBytes=" + this.confirmedBytes + ", totalSentCrc32c=" + this.cumulativeCrc32c + '}';
    }

    static interface BidiWriteObjectRequestBuilderFactory {
        public BidiWriteObjectRequest.Builder newBuilder();

        public @Nullable String bucketName();
    }
}

