/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.ApiFuture;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.SettableApiFuture;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.retrying.BasicResultRetryAlgorithm;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.ApiExceptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.StateCheckingResponseObserver;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.StreamController;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.WatchdogTimeoutException;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.BaseServiceException;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.AsyncStorageTaskException;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Buffers;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Conversions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Crc32cValue;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Hasher;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ReadCursor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ResponseContentLifecycleHandle;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ResponseContentLifecycleManager;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Retrying;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.StorageException;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.UnbufferedReadableByteChannelSession;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.ByteString;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ChecksummedData;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.Object;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ReadObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ReadObjectResponse;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ScatteringByteChannel;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class GapicUnbufferedReadableByteChannel
implements UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel,
ScatteringByteChannel {
    private static final java.lang.Object EOF_MARKER = new java.lang.Object();
    private final SettableApiFuture<Object> result;
    private final ServerStreamingCallable<ReadObjectRequest, ReadObjectResponse> read;
    private final ReadObjectRequest req;
    private final Hasher hasher;
    private final ResponseContentLifecycleManager rclm;
    private final Retrying.RetryingDependencies retryingDeps;
    private final ResultRetryAlgorithm<?> alg;
    private final SimpleBlockingQueue<java.lang.Object> queue;
    private final AtomicLong fetchOffset;
    private volatile ReadObjectObserver readObjectObserver;
    private volatile boolean open = true;
    private volatile boolean complete = false;
    private long blobOffset;
    private Object metadata;
    private ResponseContentLifecycleHandle leftovers;

    GapicUnbufferedReadableByteChannel(final SettableApiFuture<Object> result, ServerStreamingCallable<ReadObjectRequest, ReadObjectResponse> read, ReadObjectRequest req, Hasher hasher, Retrying.RetryingDependencies retryingDependencies, final ResultRetryAlgorithm<?> alg, ResponseContentLifecycleManager rclm) {
        this.result = result;
        this.read = read;
        this.req = req;
        this.hasher = hasher;
        this.fetchOffset = new AtomicLong(req.getReadOffset());
        this.blobOffset = req.getReadOffset();
        this.rclm = rclm;
        this.retryingDeps = retryingDependencies;
        this.alg = new BasicResultRetryAlgorithm<java.lang.Object>(){

            @Override
            public boolean shouldRetry(Throwable previousThrowable, java.lang.Object previousResponse) {
                boolean shouldRetry;
                boolean isWatchdogTimeout = previousThrowable instanceof StorageException && previousThrowable.getCause() instanceof WatchdogTimeoutException;
                boolean bl = shouldRetry = isWatchdogTimeout || alg.shouldRetry(previousThrowable, null);
                if (previousThrowable != null && !shouldRetry) {
                    result.setException(previousThrowable);
                }
                return shouldRetry;
            }
        };
        this.queue = new SimpleBlockingQueue(2);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (this.complete && this.open) {
            this.close();
            return -1L;
        }
        if (!this.open) {
            throw new ClosedChannelException();
        }
        long totalBufferCapacity = Buffers.totalRemaining(dsts, offset, length);
        ReadCursor c = new ReadCursor(this.blobOffset, this.blobOffset + totalBufferCapacity);
        while (c.hasRemaining()) {
            java.lang.Object take;
            if (this.leftovers != null) {
                this.leftovers.copy(c, dsts, offset, length);
                if (this.leftovers.hasRemaining()) continue;
                this.leftovers.close();
                this.leftovers = null;
                continue;
            }
            this.ensureStreamOpen();
            try {
                take = this.queue.poll();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
            if (take instanceof Throwable) {
                Throwable throwable = (Throwable)take;
                BaseServiceException coalesce = StorageException.coalesce(throwable);
                if (this.alg.shouldRetry(coalesce, null)) {
                    this.readObjectObserver = null;
                    continue;
                }
                throw new IOException(coalesce);
            }
            if (take == EOF_MARKER) {
                this.complete = true;
                break;
            }
            this.readObjectObserver.request();
            ReadObjectResponse resp = (ReadObjectResponse)take;
            ResponseContentLifecycleHandle handle = this.rclm.get(resp);
            if (resp.hasMetadata()) {
                Object respMetadata = resp.getMetadata();
                if (this.metadata == null) {
                    this.metadata = respMetadata;
                } else if (this.metadata.getGeneration() != respMetadata.getGeneration()) {
                    throw this.closeWithError(String.format("Mismatch Generation between subsequent reads. Expected %d but received %d", this.metadata.getGeneration(), respMetadata.getGeneration()));
                }
            }
            ChecksummedData checksummedData = resp.getChecksummedData();
            ByteString content = checksummedData.getContent();
            int contentSize = content.size();
            if (checksummedData.hasCrc32C()) {
                Crc32cValue.Crc32cLengthKnown expected = Crc32cValue.of(checksummedData.getCrc32C(), contentSize);
                try {
                    this.hasher.validate(expected, content.asReadOnlyByteBufferList());
                }
                catch (IOException e) {
                    this.close();
                    throw e;
                }
            }
            handle.copy(c, dsts, offset, length);
            if (handle.hasRemaining()) {
                this.leftovers = handle;
                continue;
            }
            handle.close();
        }
        long read = c.read();
        this.blobOffset += read;
        return read;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block9: {
            this.open = false;
            try {
                ReadObjectObserver obs;
                if (this.leftovers != null) {
                    this.leftovers.close();
                }
                if ((obs = this.readObjectObserver) == null || obs.cancellation.isDone()) break block9;
                obs.cancel();
                this.drainQueue();
                try {
                    obs.cancellation.get(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    InterruptedIOException ioe = new InterruptedIOException();
                    ioe.initCause(e);
                    ioe.addSuppressed(new AsyncStorageTaskException());
                    throw ioe;
                }
                catch (ExecutionException e) {
                    Throwable cause = e;
                    if (e.getCause() != null) {
                        cause = e.getCause();
                    }
                    IOException ioException = new IOException(cause);
                    ioException.addSuppressed(new AsyncStorageTaskException());
                    throw ioException;
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
            }
            finally {
                this.drainQueue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainQueue() throws IOException {
        boolean shouldInterupt = false;
        try {
            IOException ioException = null;
            while (this.queue.nonEmpty()) {
                try {
                    java.lang.Object queueValue = this.queue.poll();
                    if (queueValue instanceof ReadObjectResponse) {
                        ReadObjectResponse resp = (ReadObjectResponse)queueValue;
                        ResponseContentLifecycleHandle handle = this.rclm.get(resp);
                        handle.close();
                        continue;
                    }
                    if (queueValue != EOF_MARKER && !(queueValue instanceof Throwable)) continue;
                    break;
                }
                catch (IOException e) {
                    if (ioException == null) {
                        ioException = e;
                        continue;
                    }
                    if (ioException == e) continue;
                    ioException.addSuppressed(e);
                }
                catch (InterruptedException e) {
                    shouldInterupt = true;
                    if (ioException == null) {
                        ioException = new InterruptedIOException();
                        continue;
                    }
                    ioException.addSuppressed(e);
                }
            }
            if (ioException != null) {
                throw ioException;
            }
        }
        finally {
            if (shouldInterupt) {
                Thread.currentThread().interrupt();
            }
        }
    }

    ApiFuture<Object> getResult() {
        return this.result;
    }

    private void ensureStreamOpen() {
        if (this.readObjectObserver == null) {
            java.lang.Object peek = this.queue.peek();
            if (peek instanceof Throwable || peek == EOF_MARKER) {
                return;
            }
            this.readObjectObserver = (ReadObjectObserver)Retrying.run(this.retryingDeps, this.alg, () -> {
                ReadObjectObserver tmp = new ReadObjectObserver();
                ReadObjectRequest.Builder builder = this.req.toBuilder();
                long currentFetchOffset = this.fetchOffset.get();
                if (this.req.getReadOffset() != currentFetchOffset) {
                    builder.setReadOffset(currentFetchOffset);
                }
                if (this.metadata != null && this.req.getGeneration() == 0L) {
                    builder.setGeneration(this.metadata.getGeneration());
                }
                this.read.call(builder.build(), tmp);
                ApiExceptions.callAndTranslateApiException(tmp.open);
                return tmp;
            }, Conversions.Decoder.identity());
        }
    }

    private IOException closeWithError(String message) throws IOException {
        this.close();
        StorageException cause = new StorageException(412, message);
        throw new IOException(message, cause);
    }

    static final class SimpleBlockingQueue<T> {
        private final ArrayBlockingQueue<T> queue;

        SimpleBlockingQueue(int poolMaxSize) {
            this.queue = new ArrayBlockingQueue(poolMaxSize);
        }

        public boolean nonEmpty() {
            return !this.queue.isEmpty();
        }

        public @Nullable T peek() {
            return this.queue.peek();
        }

        public @NonNull T poll() throws InterruptedException {
            return this.queue.take();
        }

        public void offer(@NonNull T element) throws InterruptedException {
            this.queue.put(element);
        }
    }

    private final class ReadObjectObserver
    extends StateCheckingResponseObserver<ReadObjectResponse> {
        private final SettableApiFuture<Void> open = SettableApiFuture.create();
        private final SettableApiFuture<Throwable> cancellation = SettableApiFuture.create();
        private volatile StreamController controller;

        private ReadObjectObserver() {
        }

        void request() {
            this.controller.request(1);
        }

        void cancel() {
            this.controller.cancel();
        }

        @Override
        protected void onStartImpl(StreamController controller) {
            this.controller = controller;
            controller.disableAutoInboundFlowControl();
            controller.request(1);
        }

        @Override
        protected void onResponseImpl(ReadObjectResponse response) {
            try {
                this.open.set(null);
                GapicUnbufferedReadableByteChannel.this.queue.offer(response);
                GapicUnbufferedReadableByteChannel.this.fetchOffset.addAndGet(response.getChecksummedData().getContent().size());
                if (response.hasMetadata() && !GapicUnbufferedReadableByteChannel.this.result.isDone()) {
                    GapicUnbufferedReadableByteChannel.this.result.set(response.getMetadata());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Status.Code.ABORTED.toStatus().withCause(e).asRuntimeException();
            }
        }

        @Override
        protected void onErrorImpl(Throwable t) {
            if (t instanceof CancellationException) {
                this.cancellation.set(t);
            }
            if (!this.open.isDone()) {
                this.open.setException(t);
            }
            try {
                GapicUnbufferedReadableByteChannel.this.queue.offer(t);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Status.Code.ABORTED.toStatus().withCause(e).asRuntimeException();
            }
        }

        @Override
        protected void onCompleteImpl() {
            try {
                this.cancellation.set(null);
                GapicUnbufferedReadableByteChannel.this.queue.offer(EOF_MARKER);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Status.Code.ABORTED.toStatus().withCause(e).asRuntimeException();
            }
        }
    }
}

