/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BufferedWritableByteChannelSession;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;

final class LazyWriteChannel<T> {
    private final Supplier<BufferedWritableByteChannelSession<T>> sessionSupplier;
    private volatile @MonotonicNonNull BufferedWritableByteChannelSession<T> session;
    private volatile @MonotonicNonNull BufferedWritableByteChannelSession.BufferedWritableByteChannel channel;
    private boolean open = false;

    LazyWriteChannel(Supplier<BufferedWritableByteChannelSession<T>> sessionSupplier) {
        this.sessionSupplier = sessionSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull BufferedWritableByteChannelSession.BufferedWritableByteChannel getChannel() {
        if (this.channel != null) {
            return this.channel;
        }
        LazyWriteChannel lazyWriteChannel = this;
        synchronized (lazyWriteChannel) {
            if (this.channel == null) {
                this.open = true;
                this.channel = (BufferedWritableByteChannelSession.BufferedWritableByteChannel)this.getSession().open();
            }
            return this.channel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull BufferedWritableByteChannelSession<T> getSession() {
        if (this.session != null) {
            return this.session;
        }
        LazyWriteChannel lazyWriteChannel = this;
        synchronized (lazyWriteChannel) {
            if (this.session == null) {
                this.session = this.sessionSupplier.get();
            }
            return this.session;
        }
    }

    boolean isOpen() {
        return this.open && this.getChannel().isOpen();
    }
}

