/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.spi.v1;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.InternalApi;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.Storage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.Bucket;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.BucketAccessControl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.HmacKey;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.HmacKeyMetadata;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.Notification;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.ObjectAccessControl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.Policy;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.ServiceAccount;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.TestIamPermissionsResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.ServiceRpc;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.Tuple;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.spi.v1.RpcBatch;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@InternalApi
public interface StorageRpc
extends ServiceRpc {
    public Bucket create(Bucket var1, Map<Option, ?> var2);

    public StorageObject create(StorageObject var1, InputStream var2, Map<Option, ?> var3);

    public Tuple<String, Iterable<Bucket>> list(Map<Option, ?> var1);

    public Tuple<String, Iterable<StorageObject>> list(String var1, Map<Option, ?> var2);

    public Bucket get(Bucket var1, Map<Option, ?> var2);

    public StorageObject get(StorageObject var1, Map<Option, ?> var2);

    public StorageObject restore(StorageObject var1, Map<Option, ?> var2);

    public Bucket patch(Bucket var1, Map<Option, ?> var2);

    public StorageObject patch(StorageObject var1, Map<Option, ?> var2);

    public boolean delete(Bucket var1, Map<Option, ?> var2);

    public boolean delete(StorageObject var1, Map<Option, ?> var2);

    public RpcBatch createBatch();

    public StorageObject compose(Iterable<StorageObject> var1, StorageObject var2, Map<Option, ?> var3);

    public byte[] load(StorageObject var1, Map<Option, ?> var2);

    public Tuple<String, byte[]> read(StorageObject var1, Map<Option, ?> var2, long var3, int var5);

    public long read(StorageObject var1, Map<Option, ?> var2, long var3, OutputStream var5);

    public String open(StorageObject var1, Map<Option, ?> var2);

    public String open(String var1);

    public void write(String var1, byte[] var2, int var3, long var4, int var6, boolean var7);

    public long getCurrentUploadOffset(String var1);

    public StorageObject queryCompletedResumableUpload(String var1, long var2);

    public StorageObject writeWithResponse(String var1, byte[] var2, int var3, long var4, int var6, boolean var7);

    public StorageObject moveObject(String var1, String var2, String var3, Map<Option, ?> var4, Map<Option, ?> var5);

    public RewriteResponse openRewrite(RewriteRequest var1);

    public RewriteResponse continueRewrite(RewriteResponse var1);

    public BucketAccessControl getAcl(String var1, String var2, Map<Option, ?> var3);

    public boolean deleteAcl(String var1, String var2, Map<Option, ?> var3);

    public BucketAccessControl createAcl(BucketAccessControl var1, Map<Option, ?> var2);

    public BucketAccessControl patchAcl(BucketAccessControl var1, Map<Option, ?> var2);

    public List<BucketAccessControl> listAcls(String var1, Map<Option, ?> var2);

    public ObjectAccessControl getDefaultAcl(String var1, String var2);

    public boolean deleteDefaultAcl(String var1, String var2);

    public ObjectAccessControl createDefaultAcl(ObjectAccessControl var1);

    public ObjectAccessControl patchDefaultAcl(ObjectAccessControl var1);

    public List<ObjectAccessControl> listDefaultAcls(String var1);

    public ObjectAccessControl getAcl(String var1, String var2, Long var3, String var4);

    public boolean deleteAcl(String var1, String var2, Long var3, String var4);

    public ObjectAccessControl createAcl(ObjectAccessControl var1);

    public ObjectAccessControl patchAcl(ObjectAccessControl var1);

    public List<ObjectAccessControl> listAcls(String var1, String var2, Long var3);

    public HmacKey createHmacKey(String var1, Map<Option, ?> var2);

    public Tuple<String, Iterable<HmacKeyMetadata>> listHmacKeys(Map<Option, ?> var1);

    public HmacKeyMetadata updateHmacKey(HmacKeyMetadata var1, Map<Option, ?> var2);

    public HmacKeyMetadata getHmacKey(String var1, Map<Option, ?> var2);

    public void deleteHmacKey(HmacKeyMetadata var1, Map<Option, ?> var2);

    public Policy getIamPolicy(String var1, Map<Option, ?> var2);

    public Policy setIamPolicy(String var1, Policy var2, Map<Option, ?> var3);

    public TestIamPermissionsResponse testIamPermissions(String var1, List<String> var2, Map<Option, ?> var3);

    public boolean deleteNotification(String var1, String var2);

    public List<Notification> listNotifications(String var1);

    public Notification createNotification(String var1, Notification var2);

    public Notification getNotification(String var1, String var2);

    public Bucket lockRetentionPolicy(Bucket var1, Map<Option, ?> var2);

    public ServiceAccount getServiceAccount(String var1);

    @InternalApi
    public Storage getStorage();

    public static class RewriteResponse {
        public final RewriteRequest rewriteRequest;
        public final StorageObject result;
        public final long blobSize;
        public final boolean isDone;
        public final String rewriteToken;
        public final long totalBytesRewritten;

        public RewriteResponse(RewriteRequest rewriteRequest, StorageObject result, long blobSize, boolean isDone, String rewriteToken, long totalBytesRewritten) {
            this.rewriteRequest = rewriteRequest;
            this.result = result;
            this.blobSize = blobSize;
            this.isDone = isDone;
            this.rewriteToken = rewriteToken;
            this.totalBytesRewritten = totalBytesRewritten;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof RewriteResponse)) {
                return false;
            }
            RewriteResponse other = (RewriteResponse)obj;
            return Objects.equals(this.rewriteRequest, other.rewriteRequest) && Objects.equals(this.result, other.result) && Objects.equals(this.rewriteToken, other.rewriteToken) && this.blobSize == other.blobSize && Objects.equals(this.isDone, other.isDone) && this.totalBytesRewritten == other.totalBytesRewritten;
        }

        public int hashCode() {
            return Objects.hash(this.rewriteRequest, this.result, this.blobSize, this.isDone, this.rewriteToken, this.totalBytesRewritten);
        }
    }

    public static class RewriteRequest {
        public final StorageObject source;
        public final Map<Option, ?> sourceOptions;
        public final boolean overrideInfo;
        public final StorageObject target;
        public final Map<Option, ?> targetOptions;
        public final Long megabytesRewrittenPerCall;

        public RewriteRequest(StorageObject source, Map<Option, ?> sourceOptions, boolean overrideInfo, StorageObject target, Map<Option, ?> targetOptions, Long megabytesRewrittenPerCall) {
            this.source = source;
            this.sourceOptions = sourceOptions;
            this.overrideInfo = overrideInfo;
            this.target = target;
            this.targetOptions = targetOptions;
            this.megabytesRewrittenPerCall = megabytesRewrittenPerCall;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof RewriteRequest)) {
                return false;
            }
            RewriteRequest other = (RewriteRequest)obj;
            return Objects.equals(this.source, other.source) && Objects.equals(this.sourceOptions, other.sourceOptions) && Objects.equals(this.overrideInfo, other.overrideInfo) && Objects.equals(this.target, other.target) && Objects.equals(this.targetOptions, other.targetOptions) && Objects.equals(this.megabytesRewrittenPerCall, other.megabytesRewrittenPerCall);
        }

        public int hashCode() {
            return Objects.hash(this.source, this.sourceOptions, this.overrideInfo, this.target, this.targetOptions, this.megabytesRewrittenPerCall);
        }
    }

    public static enum Option {
        PREDEFINED_ACL("predefinedAcl"),
        PREDEFINED_DEFAULT_OBJECT_ACL("predefinedDefaultObjectAcl"),
        IF_METAGENERATION_MATCH("ifMetagenerationMatch"),
        IF_METAGENERATION_NOT_MATCH("ifMetagenerationNotMatch"),
        IF_GENERATION_MATCH("ifGenerationMatch"),
        IF_GENERATION_NOT_MATCH("ifGenerationNotMatch"),
        IF_SOURCE_METAGENERATION_MATCH("ifSourceMetagenerationMatch"),
        IF_SOURCE_METAGENERATION_NOT_MATCH("ifSourceMetagenerationNotMatch"),
        IF_SOURCE_GENERATION_MATCH("ifSourceGenerationMatch"),
        IF_SOURCE_GENERATION_NOT_MATCH("ifSourceGenerationNotMatch"),
        IF_DISABLE_GZIP_CONTENT("disableGzipContent"),
        PREFIX("prefix"),
        PROJECT_ID("projectId"),
        PROJECTION("projection"),
        MAX_RESULTS("maxResults"),
        PAGE_TOKEN("pageToken"),
        DELIMITER("delimiter"),
        START_OFF_SET("startOffset"),
        END_OFF_SET("endOffset"),
        MATCH_GLOB("matchGlob"),
        VERSIONS("versions"),
        FIELDS("fields"),
        CUSTOMER_SUPPLIED_KEY("customerSuppliedKey"),
        USER_PROJECT("userProject"),
        KMS_KEY_NAME("kmsKeyName"),
        SERVICE_ACCOUNT_EMAIL("serviceAccount"),
        SHOW_DELETED_KEYS("showDeletedKeys"),
        REQUESTED_POLICY_VERSION("optionsRequestedPolicyVersion"),
        DETECT_CONTENT_TYPE("detectContentType"),
        ENABLE_OBJECT_RETENTION("enableObjectRetention"),
        RETURN_RAW_INPUT_STREAM("returnRawInputStream"),
        OVERRIDE_UNLOCKED_RETENTION("overrideUnlockedRetention"),
        SOFT_DELETED("softDeleted"),
        COPY_SOURCE_ACL("copySourceAcl"),
        GENERATION("generation"),
        INCLUDE_FOLDERS_AS_PREFIXES("includeFoldersAsPrefixes"),
        X_UPLOAD_CONTENT_LENGTH("x-upload-content-length"),
        EXTRA_HEADERS("extra_headers");

        private final String value;

        private Option(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        <T> T get(Map<Option, ?> options) {
            return (T)options.get((Object)this);
        }

        String getString(Map<Option, ?> options) {
            return (String)this.get(options);
        }

        Long getLong(Map<Option, ?> options) {
            return (Long)this.get(options);
        }

        Boolean getBoolean(Map<Option, ?> options) {
            return (Boolean)this.get(options);
        }
    }
}

