/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.resourcenames.ResourceName;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FolderLocationName
implements ResourceName {
    private static final PathTemplate FOLDER_LOCATION = PathTemplate.createWithoutUrlEncoding("folders/{folder}/locations/{location}");
    private volatile Map<String, String> fieldValuesMap;
    private final String folder;
    private final String location;

    @Deprecated
    protected FolderLocationName() {
        this.folder = null;
        this.location = null;
    }

    private FolderLocationName(Builder builder) {
        this.folder = Preconditions.checkNotNull(builder.getFolder());
        this.location = Preconditions.checkNotNull(builder.getLocation());
    }

    public String getFolder() {
        return this.folder;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FolderLocationName of(String folder, String location) {
        return FolderLocationName.newBuilder().setFolder(folder).setLocation(location).build();
    }

    public static String format(String folder, String location) {
        return FolderLocationName.newBuilder().setFolder(folder).setLocation(location).build().toString();
    }

    public static FolderLocationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = FOLDER_LOCATION.validatedMatch(formattedString, "FolderLocationName.parse: formattedString not in valid format");
        return FolderLocationName.of(matchMap.get("folder"), matchMap.get("location"));
    }

    public static List<FolderLocationName> parseList(List<String> formattedStrings) {
        ArrayList<FolderLocationName> list = new ArrayList<FolderLocationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FolderLocationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FolderLocationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FolderLocationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return FOLDER_LOCATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FolderLocationName folderLocationName = this;
            synchronized (folderLocationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.folder != null) {
                        fieldMapBuilder.put("folder", this.folder);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put("location", this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return FOLDER_LOCATION.instantiate("folder", this.folder, "location", this.location);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FolderLocationName that = (FolderLocationName)o;
            return Objects.equals(this.folder, that.folder) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    public static class Builder {
        private String folder;
        private String location;

        protected Builder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getLocation() {
            return this.location;
        }

        public Builder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        private Builder(FolderLocationName folderLocationName) {
            this.folder = folderLocationName.folder;
            this.location = folderLocationName.location;
        }

        public FolderLocationName build() {
            return new FolderLocationName(this);
        }
    }
}

