/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.pathtemplate.ValidationException;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.resourcenames.ResourceName;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LogBucketName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_BUCKET = PathTemplate.createWithoutUrlEncoding("projects/{project}/locations/{location}/buckets/{bucket}");
    private static final PathTemplate ORGANIZATION_LOCATION_BUCKET = PathTemplate.createWithoutUrlEncoding("organizations/{organization}/locations/{location}/buckets/{bucket}");
    private static final PathTemplate FOLDER_LOCATION_BUCKET = PathTemplate.createWithoutUrlEncoding("folders/{folder}/locations/{location}/buckets/{bucket}");
    private static final PathTemplate BILLING_ACCOUNT_LOCATION_BUCKET = PathTemplate.createWithoutUrlEncoding("billingAccounts/{billing_account}/locations/{location}/buckets/{bucket}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String bucket;
    private final String organization;
    private final String folder;
    private final String billingAccount;

    @Deprecated
    protected LogBucketName() {
        this.project = null;
        this.location = null;
        this.bucket = null;
        this.organization = null;
        this.folder = null;
        this.billingAccount = null;
    }

    private LogBucketName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.location = Preconditions.checkNotNull(builder.getLocation());
        this.bucket = Preconditions.checkNotNull(builder.getBucket());
        this.organization = null;
        this.folder = null;
        this.billingAccount = null;
        this.pathTemplate = PROJECT_LOCATION_BUCKET;
    }

    private LogBucketName(OrganizationLocationBucketBuilder builder) {
        this.organization = Preconditions.checkNotNull(builder.getOrganization());
        this.location = Preconditions.checkNotNull(builder.getLocation());
        this.bucket = Preconditions.checkNotNull(builder.getBucket());
        this.project = null;
        this.folder = null;
        this.billingAccount = null;
        this.pathTemplate = ORGANIZATION_LOCATION_BUCKET;
    }

    private LogBucketName(FolderLocationBucketBuilder builder) {
        this.folder = Preconditions.checkNotNull(builder.getFolder());
        this.location = Preconditions.checkNotNull(builder.getLocation());
        this.bucket = Preconditions.checkNotNull(builder.getBucket());
        this.project = null;
        this.organization = null;
        this.billingAccount = null;
        this.pathTemplate = FOLDER_LOCATION_BUCKET;
    }

    private LogBucketName(BillingAccountLocationBucketBuilder builder) {
        this.billingAccount = Preconditions.checkNotNull(builder.getBillingAccount());
        this.location = Preconditions.checkNotNull(builder.getLocation());
        this.bucket = Preconditions.checkNotNull(builder.getBucket());
        this.project = null;
        this.organization = null;
        this.folder = null;
        this.pathTemplate = BILLING_ACCOUNT_LOCATION_BUCKET;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getBillingAccount() {
        return this.billingAccount;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationBucketBuilder() {
        return new Builder();
    }

    public static OrganizationLocationBucketBuilder newOrganizationLocationBucketBuilder() {
        return new OrganizationLocationBucketBuilder();
    }

    public static FolderLocationBucketBuilder newFolderLocationBucketBuilder() {
        return new FolderLocationBucketBuilder();
    }

    public static BillingAccountLocationBucketBuilder newBillingAccountLocationBucketBuilder() {
        return new BillingAccountLocationBucketBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LogBucketName of(String project, String location, String bucket) {
        return LogBucketName.newBuilder().setProject(project).setLocation(location).setBucket(bucket).build();
    }

    public static LogBucketName ofProjectLocationBucketName(String project, String location, String bucket) {
        return LogBucketName.newBuilder().setProject(project).setLocation(location).setBucket(bucket).build();
    }

    public static LogBucketName ofOrganizationLocationBucketName(String organization, String location, String bucket) {
        return LogBucketName.newOrganizationLocationBucketBuilder().setOrganization(organization).setLocation(location).setBucket(bucket).build();
    }

    public static LogBucketName ofFolderLocationBucketName(String folder, String location, String bucket) {
        return LogBucketName.newFolderLocationBucketBuilder().setFolder(folder).setLocation(location).setBucket(bucket).build();
    }

    public static LogBucketName ofBillingAccountLocationBucketName(String billingAccount, String location, String bucket) {
        return LogBucketName.newBillingAccountLocationBucketBuilder().setBillingAccount(billingAccount).setLocation(location).setBucket(bucket).build();
    }

    public static String format(String project, String location, String bucket) {
        return LogBucketName.newBuilder().setProject(project).setLocation(location).setBucket(bucket).build().toString();
    }

    public static String formatProjectLocationBucketName(String project, String location, String bucket) {
        return LogBucketName.newBuilder().setProject(project).setLocation(location).setBucket(bucket).build().toString();
    }

    public static String formatOrganizationLocationBucketName(String organization, String location, String bucket) {
        return LogBucketName.newOrganizationLocationBucketBuilder().setOrganization(organization).setLocation(location).setBucket(bucket).build().toString();
    }

    public static String formatFolderLocationBucketName(String folder, String location, String bucket) {
        return LogBucketName.newFolderLocationBucketBuilder().setFolder(folder).setLocation(location).setBucket(bucket).build().toString();
    }

    public static String formatBillingAccountLocationBucketName(String billingAccount, String location, String bucket) {
        return LogBucketName.newBillingAccountLocationBucketBuilder().setBillingAccount(billingAccount).setLocation(location).setBucket(bucket).build().toString();
    }

    public static LogBucketName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_BUCKET.matches(formattedString)) {
            Map<String, String> matchMap = PROJECT_LOCATION_BUCKET.match(formattedString);
            return LogBucketName.ofProjectLocationBucketName(matchMap.get("project"), matchMap.get("location"), matchMap.get("bucket"));
        }
        if (ORGANIZATION_LOCATION_BUCKET.matches(formattedString)) {
            Map<String, String> matchMap = ORGANIZATION_LOCATION_BUCKET.match(formattedString);
            return LogBucketName.ofOrganizationLocationBucketName(matchMap.get("organization"), matchMap.get("location"), matchMap.get("bucket"));
        }
        if (FOLDER_LOCATION_BUCKET.matches(formattedString)) {
            Map<String, String> matchMap = FOLDER_LOCATION_BUCKET.match(formattedString);
            return LogBucketName.ofFolderLocationBucketName(matchMap.get("folder"), matchMap.get("location"), matchMap.get("bucket"));
        }
        if (BILLING_ACCOUNT_LOCATION_BUCKET.matches(formattedString)) {
            Map<String, String> matchMap = BILLING_ACCOUNT_LOCATION_BUCKET.match(formattedString);
            return LogBucketName.ofBillingAccountLocationBucketName(matchMap.get("billing_account"), matchMap.get("location"), matchMap.get("bucket"));
        }
        throw new ValidationException("LogBucketName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<LogBucketName> parseList(List<String> formattedStrings) {
        ArrayList<LogBucketName> list = new ArrayList<LogBucketName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LogBucketName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LogBucketName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LogBucketName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_BUCKET.matches(formattedString) || ORGANIZATION_LOCATION_BUCKET.matches(formattedString) || FOLDER_LOCATION_BUCKET.matches(formattedString) || BILLING_ACCOUNT_LOCATION_BUCKET.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LogBucketName logBucketName = this;
            synchronized (logBucketName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put("location", this.location);
                    }
                    if (this.bucket != null) {
                        fieldMapBuilder.put("bucket", this.bucket);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put("organization", this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put("folder", this.folder);
                    }
                    if (this.billingAccount != null) {
                        fieldMapBuilder.put("billing_account", this.billingAccount);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            LogBucketName that = (LogBucketName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.bucket, that.bucket) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder) && Objects.equals(this.billingAccount, that.billingAccount);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.bucket);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.billingAccount);
    }

    public static class BillingAccountLocationBucketBuilder {
        private String billingAccount;
        private String location;
        private String bucket;

        protected BillingAccountLocationBucketBuilder() {
        }

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public String getLocation() {
            return this.location;
        }

        public String getBucket() {
            return this.bucket;
        }

        public BillingAccountLocationBucketBuilder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        public BillingAccountLocationBucketBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public BillingAccountLocationBucketBuilder setBucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public LogBucketName build() {
            return new LogBucketName(this);
        }
    }

    public static class FolderLocationBucketBuilder {
        private String folder;
        private String location;
        private String bucket;

        protected FolderLocationBucketBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getLocation() {
            return this.location;
        }

        public String getBucket() {
            return this.bucket;
        }

        public FolderLocationBucketBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderLocationBucketBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public FolderLocationBucketBuilder setBucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public LogBucketName build() {
            return new LogBucketName(this);
        }
    }

    public static class OrganizationLocationBucketBuilder {
        private String organization;
        private String location;
        private String bucket;

        protected OrganizationLocationBucketBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getBucket() {
            return this.bucket;
        }

        public OrganizationLocationBucketBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLocationBucketBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public OrganizationLocationBucketBuilder setBucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public LogBucketName build() {
            return new LogBucketName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String bucket;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getBucket() {
            return this.bucket;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setBucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        private Builder(LogBucketName logBucketName) {
            Preconditions.checkArgument(Objects.equals(logBucketName.pathTemplate, PROJECT_LOCATION_BUCKET), "toBuilder is only supported when LogBucketName has the pattern of projects/{project}/locations/{location}/buckets/{bucket}");
            this.project = logBucketName.project;
            this.location = logBucketName.location;
            this.bucket = logBucketName.bucket;
        }

        public LogBucketName build() {
            return new LogBucketName(this);
        }
    }
}

