/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.logging.v2;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.pathtemplate.ValidationException;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.resourcenames.ResourceName;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SettingsName
implements ResourceName {
    private static final PathTemplate PROJECT = PathTemplate.createWithoutUrlEncoding("projects/{project}/settings");
    private static final PathTemplate ORGANIZATION = PathTemplate.createWithoutUrlEncoding("organizations/{organization}/settings");
    private static final PathTemplate FOLDER = PathTemplate.createWithoutUrlEncoding("folders/{folder}/settings");
    private static final PathTemplate BILLING_ACCOUNT = PathTemplate.createWithoutUrlEncoding("billingAccounts/{billing_account}/settings");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String organization;
    private final String folder;
    private final String billingAccount;

    @Deprecated
    protected SettingsName() {
        this.project = null;
        this.organization = null;
        this.folder = null;
        this.billingAccount = null;
    }

    private SettingsName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.organization = null;
        this.folder = null;
        this.billingAccount = null;
        this.pathTemplate = PROJECT;
    }

    private SettingsName(OrganizationBuilder builder) {
        this.organization = Preconditions.checkNotNull(builder.getOrganization());
        this.project = null;
        this.folder = null;
        this.billingAccount = null;
        this.pathTemplate = ORGANIZATION;
    }

    private SettingsName(FolderBuilder builder) {
        this.folder = Preconditions.checkNotNull(builder.getFolder());
        this.project = null;
        this.organization = null;
        this.billingAccount = null;
        this.pathTemplate = FOLDER;
    }

    private SettingsName(BillingAccountBuilder builder) {
        this.billingAccount = Preconditions.checkNotNull(builder.getBillingAccount());
        this.project = null;
        this.organization = null;
        this.folder = null;
        this.pathTemplate = BILLING_ACCOUNT;
    }

    public String getProject() {
        return this.project;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getBillingAccount() {
        return this.billingAccount;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectBuilder() {
        return new Builder();
    }

    public static OrganizationBuilder newOrganizationBuilder() {
        return new OrganizationBuilder();
    }

    public static FolderBuilder newFolderBuilder() {
        return new FolderBuilder();
    }

    public static BillingAccountBuilder newBillingAccountBuilder() {
        return new BillingAccountBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SettingsName of(String project) {
        return SettingsName.newBuilder().setProject(project).build();
    }

    public static SettingsName ofProjectName(String project) {
        return SettingsName.newBuilder().setProject(project).build();
    }

    public static SettingsName ofOrganizationName(String organization) {
        return SettingsName.newOrganizationBuilder().setOrganization(organization).build();
    }

    public static SettingsName ofFolderName(String folder) {
        return SettingsName.newFolderBuilder().setFolder(folder).build();
    }

    public static SettingsName ofBillingAccountName(String billingAccount) {
        return SettingsName.newBillingAccountBuilder().setBillingAccount(billingAccount).build();
    }

    public static String format(String project) {
        return SettingsName.newBuilder().setProject(project).build().toString();
    }

    public static String formatProjectName(String project) {
        return SettingsName.newBuilder().setProject(project).build().toString();
    }

    public static String formatOrganizationName(String organization) {
        return SettingsName.newOrganizationBuilder().setOrganization(organization).build().toString();
    }

    public static String formatFolderName(String folder) {
        return SettingsName.newFolderBuilder().setFolder(folder).build().toString();
    }

    public static String formatBillingAccountName(String billingAccount) {
        return SettingsName.newBillingAccountBuilder().setBillingAccount(billingAccount).build().toString();
    }

    public static SettingsName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT.matches(formattedString)) {
            Map<String, String> matchMap = PROJECT.match(formattedString);
            return SettingsName.ofProjectName(matchMap.get("project"));
        }
        if (ORGANIZATION.matches(formattedString)) {
            Map<String, String> matchMap = ORGANIZATION.match(formattedString);
            return SettingsName.ofOrganizationName(matchMap.get("organization"));
        }
        if (FOLDER.matches(formattedString)) {
            Map<String, String> matchMap = FOLDER.match(formattedString);
            return SettingsName.ofFolderName(matchMap.get("folder"));
        }
        if (BILLING_ACCOUNT.matches(formattedString)) {
            Map<String, String> matchMap = BILLING_ACCOUNT.match(formattedString);
            return SettingsName.ofBillingAccountName(matchMap.get("billing_account"));
        }
        throw new ValidationException("SettingsName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<SettingsName> parseList(List<String> formattedStrings) {
        ArrayList<SettingsName> list = new ArrayList<SettingsName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SettingsName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SettingsName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SettingsName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT.matches(formattedString) || ORGANIZATION.matches(formattedString) || FOLDER.matches(formattedString) || BILLING_ACCOUNT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SettingsName settingsName = this;
            synchronized (settingsName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put("organization", this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put("folder", this.folder);
                    }
                    if (this.billingAccount != null) {
                        fieldMapBuilder.put("billing_account", this.billingAccount);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SettingsName that = (SettingsName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder) && Objects.equals(this.billingAccount, that.billingAccount);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.billingAccount);
    }

    public static class BillingAccountBuilder {
        private String billingAccount;

        protected BillingAccountBuilder() {
        }

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public BillingAccountBuilder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        public SettingsName build() {
            return new SettingsName(this);
        }
    }

    public static class FolderBuilder {
        private String folder;

        protected FolderBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public FolderBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public SettingsName build() {
            return new SettingsName(this);
        }
    }

    public static class OrganizationBuilder {
        private String organization;

        protected OrganizationBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public OrganizationBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public SettingsName build() {
            return new SettingsName(this);
        }
    }

    public static class Builder {
        private String project;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder(SettingsName settingsName) {
            Preconditions.checkArgument(Objects.equals(settingsName.pathTemplate, PROJECT), "toBuilder is only supported when SettingsName has the pattern of projects/{project}/settings");
            this.project = settingsName.project;
        }

        public SettingsName build() {
            return new SettingsName(this);
        }
    }
}

