/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.storage.control.v2;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.resourcenames.ResourceName;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class StorageLayoutName
implements ResourceName {
    private static final PathTemplate PROJECT_BUCKET = PathTemplate.createWithoutUrlEncoding("projects/{project}/buckets/{bucket}/storageLayout");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String bucket;

    @Deprecated
    protected StorageLayoutName() {
        this.project = null;
        this.bucket = null;
    }

    private StorageLayoutName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.bucket = Preconditions.checkNotNull(builder.getBucket());
    }

    public String getProject() {
        return this.project;
    }

    public String getBucket() {
        return this.bucket;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static StorageLayoutName of(String project, String bucket) {
        return StorageLayoutName.newBuilder().setProject(project).setBucket(bucket).build();
    }

    public static String format(String project, String bucket) {
        return StorageLayoutName.newBuilder().setProject(project).setBucket(bucket).build().toString();
    }

    public static StorageLayoutName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = PROJECT_BUCKET.validatedMatch(formattedString, "StorageLayoutName.parse: formattedString not in valid format");
        return StorageLayoutName.of(matchMap.get("project"), matchMap.get("bucket"));
    }

    public static List<StorageLayoutName> parseList(List<String> formattedStrings) {
        ArrayList<StorageLayoutName> list = new ArrayList<StorageLayoutName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(StorageLayoutName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<StorageLayoutName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (StorageLayoutName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_BUCKET.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            StorageLayoutName storageLayoutName = this;
            synchronized (storageLayoutName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.bucket != null) {
                        fieldMapBuilder.put("bucket", this.bucket);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_BUCKET.instantiate("project", this.project, "bucket", this.bucket);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            StorageLayoutName that = (StorageLayoutName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.bucket, that.bucket);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.bucket);
    }

    public static class Builder {
        private String project;
        private String bucket;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getBucket() {
            return this.bucket;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setBucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        private Builder(StorageLayoutName storageLayoutName) {
            this.project = storageLayoutName.project;
            this.bucket = storageLayoutName.bucket;
        }

        public StorageLayoutName build() {
            return new StorageLayoutName(this);
        }
    }
}

