/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts;

import com.google.cloud.hadoop.repackaged.gcs.io.grpc.CallCredentials;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.AltsContextUtil;
import java.util.concurrent.Executor;

final class DualCallCredentials
extends CallCredentials {
    private final CallCredentials tlsCallCredentials;
    private final CallCredentials altsCallCredentials;

    public DualCallCredentials(CallCredentials tlsCallCreds, CallCredentials altsCallCreds) {
        this.tlsCallCredentials = tlsCallCreds;
        this.altsCallCredentials = altsCallCreds;
    }

    @Override
    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
        if (AltsContextUtil.check(requestInfo.getTransportAttrs())) {
            this.altsCallCredentials.applyRequestMetadata(requestInfo, appExecutor, applier);
        } else {
            this.tlsCallCredentials.applyRequestMetadata(requestInfo, appExecutor, applier);
        }
    }
}

