/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.testing;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.EquivalentAddressGroup;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.NameResolver;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.NameResolverProvider;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.StatusOr;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;

public final class FakeNameResolverProvider
extends NameResolverProvider {
    private final URI targetUri;
    private final SocketAddress address;

    public FakeNameResolverProvider(String targetUri, SocketAddress address) {
        this.targetUri = URI.create(targetUri);
        this.address = address;
    }

    @Override
    public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (targetUri.equals(this.targetUri)) {
            return new FakeNameResolver(this.address);
        }
        return null;
    }

    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    protected int priority() {
        return 10;
    }

    @Override
    public String getDefaultScheme() {
        return this.targetUri.getScheme();
    }

    @Override
    public Collection<Class<? extends SocketAddress>> getProducedSocketAddressTypes() {
        return Collections.singleton(this.address.getClass());
    }

    private static final class FakeNameResolver
    extends NameResolver {
        private static final String AUTHORITY = "fake-authority";
        private final SocketAddress address;
        private volatile boolean shutdown;

        private FakeNameResolver(SocketAddress address) {
            this.address = address;
        }

        @Override
        public void start(NameResolver.Listener2 listener) {
            if (this.shutdown) {
                listener.onError(Status.FAILED_PRECONDITION.withDescription("Resolver is shutdown"));
            } else {
                listener.onResult2(NameResolver.ResolutionResult.newBuilder().setAddressesOrError(StatusOr.fromValue(ImmutableList.of(new EquivalentAddressGroup(this.address)))).build());
            }
        }

        @Override
        public String getServiceAuthority() {
            return AUTHORITY;
        }

        @Override
        public void shutdown() {
            this.shutdown = true;
        }
    }
}

