/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.internal.view;

import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.common.AttributeKey;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.common.Attributes;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.common.AttributesBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.internal.ImmutableKeyValuePairs;
import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

abstract class FilteredAttributes
implements Attributes {
    private final Object[] sourceData;
    private final int hashcode;
    private final int size;

    private FilteredAttributes(Object[] sourceData, int hashcode, int size) {
        this.sourceData = sourceData;
        this.hashcode = hashcode;
        this.size = size;
    }

    static Attributes create(Attributes source, Set<AttributeKey<?>> includedKeys) {
        if (!(source instanceof ImmutableKeyValuePairs)) {
            source = FilteredAttributes.convertToStandardImplementation(source);
        }
        if (!(source instanceof ImmutableKeyValuePairs)) {
            throw new IllegalStateException("Expected ImmutableKeyValuePairs based implementation of Attributes. This is a programming error.");
        }
        Object[] sourceData = ((ImmutableKeyValuePairs)((Object)source)).getData();
        int filteredIndices = 0;
        BitSet filteredIndicesBitSet = source.size() > 32 ? new BitSet(source.size()) : null;
        int hashcode = 1;
        int size = 0;
        for (int i = 0; i < sourceData.length; i += 2) {
            int filterIndex = i / 2;
            if (!includedKeys.contains(sourceData[i])) {
                if (filteredIndicesBitSet != null) {
                    filteredIndicesBitSet.set(filterIndex);
                    continue;
                }
                filteredIndices |= 1 << filterIndex;
                continue;
            }
            hashcode = 31 * hashcode + sourceData[i].hashCode();
            hashcode = 31 * hashcode + sourceData[i + 1].hashCode();
            ++size;
        }
        if (size == 0) {
            return Attributes.empty();
        }
        return filteredIndicesBitSet != null ? new RegularFilteredAttributes(sourceData, hashcode, size, filteredIndicesBitSet) : new SmallFilteredAttributes(sourceData, hashcode, size, filteredIndices);
    }

    private static Attributes convertToStandardImplementation(Attributes source) {
        AttributesBuilder builder = Attributes.builder();
        source.forEach((key, value) -> FilteredAttributes.putInBuilder(builder, key, value));
        return builder.build();
    }

    @Override
    @Nullable
    public <T> T get(AttributeKey<T> key) {
        if (key == null) {
            return null;
        }
        for (int i = 0; i < this.sourceData.length; i += 2) {
            if (!key.equals(this.sourceData[i]) || !this.includeIndexInOutput(i)) continue;
            return (T)this.sourceData[i + 1];
        }
        return null;
    }

    @Override
    public void forEach(BiConsumer<? super AttributeKey<?>, ? super Object> consumer) {
        for (int i = 0; i < this.sourceData.length; i += 2) {
            if (!this.includeIndexInOutput(i)) continue;
            consumer.accept((AttributeKey)this.sourceData[i], this.sourceData[i + 1]);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Map<AttributeKey<?>, Object> asMap() {
        LinkedHashMap<AttributeKey, Object> result = new LinkedHashMap<AttributeKey, Object>(this.size);
        for (int i = 0; i < this.sourceData.length; i += 2) {
            if (!this.includeIndexInOutput(i)) continue;
            result.put((AttributeKey)this.sourceData[i], this.sourceData[i + 1]);
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public AttributesBuilder toBuilder() {
        AttributesBuilder builder = Attributes.builder();
        for (int i = 0; i < this.sourceData.length; i += 2) {
            if (!this.includeIndexInOutput(i)) continue;
            FilteredAttributes.putInBuilder(builder, (AttributeKey)this.sourceData[i], this.sourceData[i + 1]);
        }
        return builder;
    }

    private static <T> void putInBuilder(AttributesBuilder builder, AttributeKey<T> key, T value) {
        builder.put(key, value);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof FilteredAttributes)) {
            return false;
        }
        FilteredAttributes that = (FilteredAttributes)object;
        if (this.size() != that.size()) {
            return false;
        }
        int thisIndex = 0;
        int thatIndex = 0;
        while (true) {
            boolean thatDone;
            boolean thisDone = thisIndex >= this.sourceData.length;
            boolean bl = thatDone = thatIndex >= that.sourceData.length;
            if (!thisDone && !this.includeIndexInOutput(thisIndex)) {
                thisIndex += 2;
                continue;
            }
            if (!thatDone && !that.includeIndexInOutput(thatIndex)) {
                thatIndex += 2;
                continue;
            }
            if (thisDone && thatDone) break;
            if (thisDone != thatDone) {
                return false;
            }
            if (!Objects.equals(this.sourceData[thisIndex], that.sourceData[thatIndex]) || !Objects.equals(this.sourceData[thisIndex + 1], that.sourceData[thatIndex + 1])) {
                return false;
            }
            thisIndex += 2;
            thatIndex += 2;
        }
        return true;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(",", "FilteredAttributes{", "}");
        for (int i = 0; i < this.sourceData.length; i += 2) {
            if (!this.includeIndexInOutput(i)) continue;
            joiner.add(((AttributeKey)this.sourceData[i]).getKey() + "=" + this.sourceData[i + 1]);
        }
        return joiner.toString();
    }

    abstract boolean includeIndexInOutput(int var1);

    private static class SmallFilteredAttributes
    extends FilteredAttributes {
        private static final int BITS_PER_INTEGER = 32;
        private final int filteredIndices;

        private SmallFilteredAttributes(Object[] sourceData, int hashcode, int size, int filteredIndices) {
            super(sourceData, hashcode, size);
            this.filteredIndices = filteredIndices;
        }

        @Override
        boolean includeIndexInOutput(int sourceIndex) {
            return (this.filteredIndices & 1 << sourceIndex / 2) == 0;
        }
    }

    private static class RegularFilteredAttributes
    extends FilteredAttributes {
        private final BitSet bitSet;

        private RegularFilteredAttributes(Object[] sourceData, int hashcode, int size, BitSet bitSet) {
            super(sourceData, hashcode, size);
            this.bitSet = bitSet;
        }

        @Override
        boolean includeIndexInOutput(int sourceIndex) {
            return !this.bitSet.get(sourceIndex / 2);
        }
    }
}

