/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.math.LongMath;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.Timestamp;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.util.Timestamps;
import java.time.Instant;

class JavaTimeConversions {
    static final long NANOS_PER_SECOND = 1000000000L;

    private JavaTimeConversions() {
    }

    public static Instant toJavaInstant(Timestamp timestamp) {
        Preconditions.checkNotNull(timestamp);
        timestamp = JavaTimeConversions.normalizedTimestamp(timestamp.getSeconds(), timestamp.getNanos());
        return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
    }

    public static Timestamp toProtoTimestamp(Instant instant) {
        Preconditions.checkNotNull(instant);
        return JavaTimeConversions.normalizedTimestamp(instant.getEpochSecond(), instant.getNano());
    }

    static Timestamp normalizedTimestamp(long seconds, int nanos) {
        if ((long)nanos <= -1000000000L || (long)nanos >= 1000000000L) {
            seconds = LongMath.checkedAdd(seconds, (long)nanos / 1000000000L);
            nanos = (int)((long)nanos % 1000000000L);
        }
        if (nanos < 0) {
            nanos = (int)((long)nanos + 1000000000L);
            seconds = LongMath.checkedSubtract(seconds, 1L);
        }
        Timestamp timestamp = Timestamp.newBuilder().setSeconds(seconds).setNanos(nanos).build();
        return Timestamps.checkValid(timestamp);
    }
}

