/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import com.google.cloud.logging.MonitoredResourceUtil;
import com.google.cloud.logging.ResourceTypeEnvironmentGetter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.function.Supplier;

public final class MetadataLoader {
    public static final String ENV_FLEXIBLE = "flex";
    public static final String ENV_STANDARD = "standard";
    private final ResourceTypeEnvironmentGetter getter;
    private final ImmutableMap<MonitoredResourceUtil.Label, Supplier<String>> labelResolvers = ImmutableMap.builder().put(MonitoredResourceUtil.Label.ClusterName, this::getClusterName).put(MonitoredResourceUtil.Label.ConfigurationName, this::getConfigName).put(MonitoredResourceUtil.Label.ContainerName, this::getContainerName).put(MonitoredResourceUtil.Label.Env, this::getEnv).put(MonitoredResourceUtil.Label.FunctionName, this::getFunctionName).put(MonitoredResourceUtil.Label.InstanceId, this::getInstanceId).put(MonitoredResourceUtil.Label.InstanceName, this::getInstanceName).put(MonitoredResourceUtil.Label.CloudRunJobName, this::getCloudRunJobName).put(MonitoredResourceUtil.Label.CloudRunJobExecutionName, this::getCloudRunJobExecutionName).put(MonitoredResourceUtil.Label.CloudRunJobTaskIndex, this::getCloudRunJobTaskIndex).put(MonitoredResourceUtil.Label.CloudRunJobTaskAttempt, this::getCloudRunJobTaskAttempt).put(MonitoredResourceUtil.Label.CloudRunLocation, this::getCloudRunLocation).put(MonitoredResourceUtil.Label.GKELocation, this::getGKELocation).put(MonitoredResourceUtil.Label.ModuleId, this::getModuleId).put(MonitoredResourceUtil.Label.NamespaceName, this::getNamespaceName).put(MonitoredResourceUtil.Label.PodName, this::getPodName).put(MonitoredResourceUtil.Label.ProjectId, this::getProjectId).put(MonitoredResourceUtil.Label.Region, this::getRegion).put(MonitoredResourceUtil.Label.RevisionName, this::getRevisionName).put(MonitoredResourceUtil.Label.ServiceName, this::getServiceName).put(MonitoredResourceUtil.Label.VersionId, this::getVersionId).put(MonitoredResourceUtil.Label.Zone, this::getZone).buildOrThrow();

    public MetadataLoader(ResourceTypeEnvironmentGetter getter) {
        this.getter = getter;
    }

    public String getValue(MonitoredResourceUtil.Label label) {
        Supplier<String> lambda = this.labelResolvers.get((Object)label);
        if (lambda != null) {
            return lambda.get();
        }
        return null;
    }

    private String getClusterName() {
        return this.getter.getAttribute("instance/attributes/cluster-name");
    }

    private String getConfigName() {
        return this.getter.getEnv("K_CONFIGURATION");
    }

    private String getContainerName() {
        return this.getter.getEnv("CONTAINER_NAME");
    }

    private String getEnv() {
        String value = this.getter.getAttribute("instance/attributes/startup-script");
        if ("/var/lib/flex/startup_script.sh".equals(value)) {
            return ENV_FLEXIBLE;
        }
        return ENV_STANDARD;
    }

    private String getFunctionName() {
        String value = this.getter.getEnv("K_SERVICE");
        if (value == null) {
            value = this.getter.getEnv("FUNCTION_NAME");
        }
        return value;
    }

    private String getInstanceId() {
        return this.getter.getAttribute("instance/id");
    }

    private String getInstanceName() {
        return this.getter.getAttribute("instance/name");
    }

    private String getCloudRunJobName() {
        return this.getter.getEnv("CLOUD_RUN_JOB");
    }

    private String getCloudRunJobExecutionName() {
        return this.getter.getEnv("CLOUD_RUN_EXECUTION");
    }

    private String getCloudRunJobTaskIndex() {
        return this.getter.getEnv("CLOUD_RUN_TASK_INDEX");
    }

    private String getCloudRunJobTaskAttempt() {
        return this.getter.getEnv("CLOUD_RUN_TASK_ATTEMPT");
    }

    private String getCloudRunLocation() {
        return this.getRegion();
    }

    private String getGKELocation() {
        return this.getZone();
    }

    private String getModuleId() {
        return this.getter.getEnv("GAE_SERVICE");
    }

    private String getNamespaceName() {
        String value = null;
        try {
            value = new String(Files.readAllBytes(Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/namespace", new String[0])), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            value = this.getter.getEnv("NAMESPACE_NAME");
        }
        return value;
    }

    private String getPodName() {
        String value = this.getter.getEnv("POD_NAME");
        if (value != null) {
            return value;
        }
        return this.getter.getEnv("HOSTNAME");
    }

    private String getProjectId() {
        return this.getter.getAttribute("project/project-id");
    }

    private String getRegion() {
        String loc = this.getter.getAttribute("instance/region");
        if (loc != null) {
            return loc.substring(loc.lastIndexOf(47) + 1);
        }
        return null;
    }

    private String getRevisionName() {
        return this.getter.getEnv("K_REVISION");
    }

    private String getServiceName() {
        return this.getter.getEnv("K_SERVICE");
    }

    private String getVersionId() {
        return this.getter.getEnv("GAE_VERSION");
    }

    private String getZone() {
        String loc = this.getter.getAttribute("instance/zone");
        if (loc != null) {
            return loc.substring(loc.lastIndexOf(47) + 1);
        }
        return null;
    }
}

