/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.MonitoredResource;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Strings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMultimap;
import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.LoggingEnhancer;
import com.google.cloud.logging.MetadataLoader;
import com.google.cloud.logging.ResourceTypeEnvironmentGetter;
import com.google.cloud.logging.ResourceTypeEnvironmentGetterImpl;
import com.google.cloud.logging.TraceLoggingEnhancer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MonitoredResourceUtil {
    private static final String APPENGINE_LABEL_PREFIX = "appengine.googleapis.com/";
    private static final String CLOUD_RUN_JOB_LABEL_PREFIX = "run.googleapis.com/";
    protected static final String PORJECTID_LABEL = Label.ProjectId.getKey();
    private static final ImmutableMultimap<String, Label> RESOURCE_TYPE_WITH_LABELS = ImmutableMultimap.builder().putAll(Resource.CLOUD_FUNCTION.getKey(), Label.FunctionName, Label.Region).putAll(Resource.CLOUD_RUN.getKey(), (Label[])new Label[]{Label.RevisionName, Label.ServiceName, Label.CloudRunLocation, Label.ConfigurationName}).putAll(Resource.CLOUD_RUN_JOB.getKey(), (Label[])new Label[]{Label.CloudRunJobName, Label.CloudRunLocation}).putAll(Resource.APP_ENGINE.getKey(), (Label[])new Label[]{Label.ModuleId, Label.VersionId, Label.Zone, Label.Env}).putAll(Resource.GCE_INSTANCE.getKey(), (Label[])new Label[]{Label.InstanceId, Label.Zone}).putAll(Resource.K8S_CONTAINER.getKey(), (Label[])new Label[]{Label.GKELocation, Label.ClusterName, Label.NamespaceName, Label.PodName, Label.ContainerName}).build();
    private static final Map<String, MonitoredResource> cachedMonitoredResources = new HashMap<String, MonitoredResource>();
    private static ResourceTypeEnvironmentGetter getter = new ResourceTypeEnvironmentGetterImpl();
    private static MetadataLoader metadataLoader = new MetadataLoader(getter);

    private MonitoredResourceUtil() {
    }

    protected static void setEnvironmentGetter(ResourceTypeEnvironmentGetter getter) {
        MonitoredResourceUtil.getter = getter;
        metadataLoader = new MetadataLoader(getter);
    }

    public static MonitoredResource getResource(String projectId, String resourceType) {
        MonitoredResource result;
        if (projectId == null || projectId.trim().isEmpty()) {
            projectId = metadataLoader.getValue(Label.ProjectId);
        }
        if ((result = cachedMonitoredResources.get(projectId + "/" + resourceType)) != null) {
            return result;
        }
        if (Strings.isNullOrEmpty(resourceType)) {
            Resource detectedResourceType = MonitoredResourceUtil.detectResourceType();
            resourceType = detectedResourceType.getKey();
        }
        MonitoredResource.Builder builder = MonitoredResource.newBuilder(resourceType).addLabel(Label.ProjectId.getKey(), projectId);
        for (Label label : RESOURCE_TYPE_WITH_LABELS.get((Object)resourceType)) {
            String value = metadataLoader.getValue(label);
            if (value == null) continue;
            builder.addLabel(label.getKey(), value);
        }
        result = builder.build();
        cachedMonitoredResources.put(projectId + "/" + resourceType, result);
        return result;
    }

    private static Resource detectResourceType() {
        if (getter.getAttribute("") == null) {
            return Resource.GLOBAL;
        }
        if (getter.getEnv("FUNCTION_SIGNATURE_TYPE") != null && getter.getEnv("FUNCTION_TARGET") != null) {
            return Resource.CLOUD_FUNCTION;
        }
        if (getter.getEnv("K_SERVICE") != null && getter.getEnv("K_REVISION") != null && getter.getEnv("K_CONFIGURATION") != null) {
            return Resource.CLOUD_RUN;
        }
        if (getter.getEnv("CLOUD_RUN_JOB") != null && getter.getEnv("CLOUD_RUN_EXECUTION") != null && getter.getEnv("CLOUD_RUN_TASK_INDEX") != null && getter.getEnv("CLOUD_RUN_TASK_ATTEMPT") != null) {
            return Resource.CLOUD_RUN_JOB;
        }
        if (getter.getEnv("GAE_INSTANCE") != null && getter.getEnv("GAE_SERVICE") != null && getter.getEnv("GAE_VERSION") != null) {
            return Resource.APP_ENGINE;
        }
        if (getter.getAttribute("instance/attributes/cluster-name") != null) {
            return Resource.K8S_CONTAINER;
        }
        if (getter.getAttribute("instance/preempted") != null && getter.getAttribute("instance/cpu-platform") != null && getter.getAttribute("instance/attributes/gae_app_bucket") == null) {
            return Resource.GCE_INSTANCE;
        }
        return Resource.GLOBAL;
    }

    public static List<LoggingEnhancer> getResourceEnhancers() {
        Resource resourceType = MonitoredResourceUtil.detectResourceType();
        return MonitoredResourceUtil.createEnhancers(resourceType);
    }

    private static List<LoggingEnhancer> createEnhancers(Resource resourceType) {
        ArrayList<LoggingEnhancer> enhancers = new ArrayList<LoggingEnhancer>(2);
        if (resourceType == Resource.APP_ENGINE) {
            enhancers.add(new TraceLoggingEnhancer(APPENGINE_LABEL_PREFIX));
            if ("flex".equals(metadataLoader.getValue(Label.Env))) {
                enhancers.add(new LabelLoggingEnhancer(APPENGINE_LABEL_PREFIX, ImmutableList.of(Label.InstanceName)));
            }
        } else if (resourceType == Resource.CLOUD_RUN_JOB) {
            enhancers.add(new LabelLoggingEnhancer(CLOUD_RUN_JOB_LABEL_PREFIX, ImmutableList.of(Label.CloudRunJobExecutionName, Label.CloudRunJobTaskIndex, Label.CloudRunJobTaskAttempt)));
        }
        return enhancers;
    }

    protected static enum Label {
        ClusterName("cluster_name"),
        ConfigurationName("configuration_name"),
        ContainerName("container_name"),
        Env("env"),
        FunctionName("function_name"),
        InstanceId("instance_id"),
        InstanceName("instance_name"),
        CloudRunJobName("job_name"),
        CloudRunJobExecutionName("execution_name"),
        CloudRunJobTaskIndex("task_index"),
        CloudRunJobTaskAttempt("task_attempt"),
        CloudRunLocation("location"),
        GKELocation("location"),
        ModuleId("module_id"),
        NamespaceName("namespace_name"),
        PodName("pod_name"),
        ProjectId("project_id"),
        Region("region"),
        RevisionName("revision_name"),
        ServiceName("service_name"),
        VersionId("version_id"),
        Zone("zone");

        private final String key;

        private Label(String key) {
            this.key = key;
        }

        String getKey() {
            return this.key;
        }
    }

    private static enum Resource {
        CLOUD_RUN("cloud_run_revision"),
        CLOUD_RUN_JOB("cloud_run_job"),
        CLOUD_FUNCTION("cloud_function"),
        APP_ENGINE("gae_app"),
        GCE_INSTANCE("gce_instance"),
        K8S_CONTAINER("k8s_container"),
        GLOBAL("global");

        private final String key;

        private Resource(String key) {
            this.key = key;
        }

        String getKey() {
            return this.key;
        }
    }

    private static class LabelLoggingEnhancer
    implements LoggingEnhancer {
        private final Map<String, String> labels = new HashMap<String, String>();

        LabelLoggingEnhancer(String prefix, List<Label> labelNames) {
            if (labelNames != null) {
                for (Label labelName : labelNames) {
                    String fullLabelName;
                    String string = fullLabelName = prefix != null ? prefix + labelName.getKey() : labelName.getKey();
                    String labelValue = metadataLoader.getValue(labelName);
                    if (labelValue == null) continue;
                    this.labels.put(fullLabelName, labelValue);
                }
            }
        }

        @Override
        public void enhanceLogEntry(LogEntry.Builder logEntry) {
            for (Map.Entry<String, String> label : this.labels.entrySet()) {
                logEntry.addLabel(label.getKey(), label.getValue());
            }
        }
    }
}

