/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.fs.Path;

public class GoogleHadoopFileSystem
extends GoogleHadoopFileSystemBase {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private String rootBucket;

    public GoogleHadoopFileSystem() {
    }

    @VisibleForTesting
    GoogleHadoopFileSystem(GoogleCloudStorageFileSystem gcsfs) {
        super(gcsfs);
    }

    @Override
    @VisibleForTesting
    protected void configureBuckets(GoogleCloudStorageFileSystem gcsFs, String systemBucketName, boolean createSystemBucket) throws IOException {
        super.configureBuckets(gcsFs, systemBucketName, createSystemBucket);
        this.rootBucket = this.initUri.getAuthority();
        if (this.rootBucket != null) {
            this.pathCodec.getPath(this.rootBucket, null, true);
        } else if (this.systemBucket != null) {
            ((GoogleLogger.Api)logger.atWarning()).log("GHFS.configureBuckets: Warning. No GCS bucket provided. Falling back on deprecated fs.gs.system.bucket.");
            this.rootBucket = this.systemBucket;
        } else {
            throw new IllegalArgumentException(String.format("No bucket specified in GCS URI: %s", this.initUri));
        }
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.configureBuckets: GoogleHadoopFileSystem root in bucket: %s", this.rootBucket);
    }

    @Override
    protected void checkPath(Path path) {
        super.checkPath(path);
        URI uri = path.toUri();
        String bucket = uri.getAuthority();
        if (bucket == null || bucket.equals(this.rootBucket)) {
            return;
        }
        String msg = String.format("Wrong bucket: %s, in path: %s, expected bucket: %s", bucket, path, this.rootBucket);
        throw new IllegalArgumentException(msg);
    }

    @VisibleForTesting
    String getRootBucketName() {
        return this.rootBucket;
    }

    @Override
    protected String getHomeDirectorySubpath() {
        return "user/" + System.getProperty("user.name");
    }

    @Override
    public Path getHadoopPath(URI gcsPath) {
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.getHadoopPath: %s", gcsPath);
        if (gcsPath.equals(this.getGcsPath(this.getFileSystemRoot()))) {
            return this.getFileSystemRoot();
        }
        StorageResourceId resourceId = this.pathCodec.validatePathAndGetId(gcsPath, true);
        Preconditions.checkArgument(!resourceId.isRoot(), "Missing authority in gcsPath '%s'", (Object)gcsPath);
        Preconditions.checkArgument(resourceId.getBucketName().equals(this.rootBucket), "Authority of URI '%s' doesn't match root bucket '%s'", (Object)resourceId.getBucketName(), (Object)this.rootBucket);
        Path hadoopPath = new Path(this.getScheme() + "://" + this.rootBucket + '/' + resourceId.getObjectName());
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.getHadoopPath: %s -> %s", (Object)gcsPath, (Object)hadoopPath);
        return hadoopPath;
    }

    @Override
    public URI getGcsPath(Path hadoopPath) {
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.getGcsPath: %s", hadoopPath);
        Path resolvedPath = this.makeQualified(hadoopPath);
        String objectName = resolvedPath.toUri().getPath();
        if (objectName != null && resolvedPath.isAbsolute()) {
            objectName = objectName.substring(1);
        }
        URI gcsPath = this.pathCodec.getPath(this.rootBucket, objectName, true);
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.getGcsPath: %s -> %s", (Object)hadoopPath, (Object)gcsPath);
        return gcsPath;
    }

    @Override
    public String getScheme() {
        return "gs";
    }

    @Override
    public Path getFileSystemRoot() {
        return new Path(this.getScheme() + "://" + this.rootBucket + '/');
    }

    @Override
    public Path getDefaultWorkingDirectory() {
        return this.getFileSystemRoot();
    }
}

