/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.apache;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpTransport;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.apache.ApacheHttpRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.apache.HttpExtensionMethod;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.apache.SSLSocketFactoryExtension;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.Beta;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.SecurityUtils;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.SslUtils;
import com.google.cloud.hadoop.repackaged.gcs.org.apache.http.HttpHost;
import com.google.cloud.hadoop.repackaged.gcs.org.apache.http.HttpVersion;
import com.google.cloud.hadoop.repackaged.gcs.org.apache.http.client.HttpClient;
import com.google.cloud.hadoop.repackaged.gcs.org.apache.http.client.methods.HttpDelete;
import com.google.cloud.hadoop.repackaged.gcs.org.apache.http.client.methods.HttpGet;
import com.google.cloud.hadoop.repackaged.gcs.org.apache.http.client.methods.HttpHead;
import com.google.cloud.hadoop.repackaged.gcs.org.apache.http.client.methods.HttpOptions;
import com.google.cloud.hadoop.repackaged.gcs.org.apache.http.client.methods.HttpPost;
import com.google.cloud.hadoop.repackaged.gcs.org.apache.http.client.methods.HttpPut;
import com.google.cloud.hadoop.repackaged.gcs.org.apache.http.client.methods.HttpRequestBase;
import com.google.cloud.hadoop.repackaged.gcs.org.apache.http.client.methods.HttpTrace;
import com.google.cloud.hadoop.repackaged.gcs.org.apache.http.conn.params.ConnManagerParams;
import com.google.cloud.hadoop.repackaged.gcs.org.apache.http.conn.params.ConnPerRouteBean;
import com.google.cloud.hadoop.repackaged.gcs.org.apache.http.conn.params.ConnRouteParams;
import com.google.cloud.hadoop.repackaged.gcs.org.apache.http.conn.scheme.PlainSocketFactory;
import com.google.cloud.hadoop.repackaged.gcs.org.apache.http.conn.scheme.Scheme;
import com.google.cloud.hadoop.repackaged.gcs.org.apache.http.conn.scheme.SchemeRegistry;
import com.google.cloud.hadoop.repackaged.gcs.org.apache.http.conn.ssl.SSLSocketFactory;
import com.google.cloud.hadoop.repackaged.gcs.org.apache.http.impl.client.DefaultHttpClient;
import com.google.cloud.hadoop.repackaged.gcs.org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import com.google.cloud.hadoop.repackaged.gcs.org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import com.google.cloud.hadoop.repackaged.gcs.org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import com.google.cloud.hadoop.repackaged.gcs.org.apache.http.params.BasicHttpParams;
import com.google.cloud.hadoop.repackaged.gcs.org.apache.http.params.HttpConnectionParams;
import com.google.cloud.hadoop.repackaged.gcs.org.apache.http.params.HttpParams;
import com.google.cloud.hadoop.repackaged.gcs.org.apache.http.params.HttpProtocolParams;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;

public final class ApacheHttpTransport
extends HttpTransport {
    private final HttpClient httpClient;

    public ApacheHttpTransport() {
        this(ApacheHttpTransport.newDefaultHttpClient());
    }

    public ApacheHttpTransport(HttpClient httpClient) {
        this.httpClient = httpClient;
        HttpParams params = httpClient.getParams();
        if (params == null) {
            params = ApacheHttpTransport.newDefaultHttpClient().getParams();
        }
        HttpProtocolParams.setVersion(params, HttpVersion.HTTP_1_1);
        params.setBooleanParameter("http.protocol.handle-redirects", false);
    }

    public static DefaultHttpClient newDefaultHttpClient() {
        return ApacheHttpTransport.newDefaultHttpClient(SSLSocketFactory.getSocketFactory(), ApacheHttpTransport.newDefaultHttpParams(), ProxySelector.getDefault());
    }

    static HttpParams newDefaultHttpParams() {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setStaleCheckingEnabled(params, false);
        HttpConnectionParams.setSocketBufferSize(params, 8192);
        ConnManagerParams.setMaxTotalConnections(params, 200);
        ConnManagerParams.setMaxConnectionsPerRoute(params, new ConnPerRouteBean(20));
        return params;
    }

    static DefaultHttpClient newDefaultHttpClient(SSLSocketFactory socketFactory, HttpParams params, ProxySelector proxySelector) {
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", PlainSocketFactory.getSocketFactory(), 80));
        registry.register(new Scheme("https", socketFactory, 443));
        ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager(params, registry);
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient(connectionManager, params);
        defaultHttpClient.setHttpRequestRetryHandler(new DefaultHttpRequestRetryHandler(0, false));
        if (proxySelector != null) {
            defaultHttpClient.setRoutePlanner(new ProxySelectorRoutePlanner(registry, proxySelector));
        }
        return defaultHttpClient;
    }

    @Override
    public boolean supportsMethod(String method) {
        return true;
    }

    @Override
    protected ApacheHttpRequest buildRequest(String method, String url) {
        HttpRequestBase requestBase = method.equals("DELETE") ? new HttpDelete(url) : (method.equals("GET") ? new HttpGet(url) : (method.equals("HEAD") ? new HttpHead(url) : (method.equals("POST") ? new HttpPost(url) : (method.equals("PUT") ? new HttpPut(url) : (method.equals("TRACE") ? new HttpTrace(url) : (method.equals("OPTIONS") ? new HttpOptions(url) : new HttpExtensionMethod(method, url)))))));
        return new ApacheHttpRequest(this.httpClient, requestBase);
    }

    @Override
    public void shutdown() {
        this.httpClient.getConnectionManager().shutdown();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public static final class Builder {
        private SSLSocketFactory socketFactory = SSLSocketFactory.getSocketFactory();
        private HttpParams params = ApacheHttpTransport.newDefaultHttpParams();
        private ProxySelector proxySelector = ProxySelector.getDefault();

        public Builder setProxy(HttpHost proxy) {
            ConnRouteParams.setDefaultProxy(this.params, proxy);
            if (proxy != null) {
                this.proxySelector = null;
            }
            return this;
        }

        public Builder setProxySelector(ProxySelector proxySelector) {
            this.proxySelector = proxySelector;
            if (proxySelector != null) {
                ConnRouteParams.setDefaultProxy(this.params, null);
            }
            return this;
        }

        public Builder trustCertificatesFromJavaKeyStore(InputStream keyStoreStream, String storePass) throws GeneralSecurityException, IOException {
            KeyStore trustStore = SecurityUtils.getJavaKeyStore();
            SecurityUtils.loadKeyStore(trustStore, keyStoreStream, storePass);
            return this.trustCertificates(trustStore);
        }

        public Builder trustCertificatesFromStream(InputStream certificateStream) throws GeneralSecurityException, IOException {
            KeyStore trustStore = SecurityUtils.getJavaKeyStore();
            trustStore.load(null, null);
            SecurityUtils.loadKeyStoreFromCertificates(trustStore, SecurityUtils.getX509CertificateFactory(), certificateStream);
            return this.trustCertificates(trustStore);
        }

        public Builder trustCertificates(KeyStore trustStore) throws GeneralSecurityException {
            SSLContext sslContext = SslUtils.getTlsSslContext();
            SslUtils.initSslContext(sslContext, trustStore, SslUtils.getPkixTrustManagerFactory());
            return this.setSocketFactory(new SSLSocketFactoryExtension(sslContext));
        }

        @Beta
        public Builder doNotValidateCertificate() throws GeneralSecurityException {
            this.socketFactory = new SSLSocketFactoryExtension(SslUtils.trustAllSSLContext());
            this.socketFactory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            return this;
        }

        public Builder setSocketFactory(SSLSocketFactory socketFactory) {
            this.socketFactory = Preconditions.checkNotNull(socketFactory);
            return this;
        }

        public SSLSocketFactory getSSLSocketFactory() {
            return this.socketFactory;
        }

        public HttpParams getHttpParams() {
            return this.params;
        }

        public ApacheHttpTransport build() {
            return new ApacheHttpTransport(ApacheHttpTransport.newDefaultHttpClient(this.socketFactory, this.params, this.proxySelector));
        }
    }
}

