/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.VerificationAttributes;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class GoogleCloudStorageItemInfo {
    public static final GoogleCloudStorageItemInfo ROOT_INFO = new GoogleCloudStorageItemInfo(StorageResourceId.ROOT, 0L, 0L, null, null);
    private static final ImmutableMap<String, byte[]> EMPTY_METADATA = ImmutableMap.of();
    private final StorageResourceId resourceId;
    private final long creationTime;
    private final long size;
    private final String location;
    private final String storageClass;
    private final String contentType;
    private final String contentEncoding;
    private final Map<String, byte[]> metadata;
    private final long contentGeneration;
    private final long metaGeneration;
    private final VerificationAttributes verificationAttributes;

    public static GoogleCloudStorageItemInfo createInferredDirectory(StorageResourceId resourceId) {
        Preconditions.checkArgument(resourceId != null, "resourceId must not be null");
        return new GoogleCloudStorageItemInfo(resourceId, 0L, 0L, null, null);
    }

    public static GoogleCloudStorageItemInfo createNotFound(StorageResourceId resourceId) {
        Preconditions.checkArgument(resourceId != null, "resourceId must not be null");
        return new GoogleCloudStorageItemInfo(resourceId, 0L, -1L, null, null);
    }

    public GoogleCloudStorageItemInfo(StorageResourceId resourceId, long creationTime, long size, String location, String storageClass) {
        this(resourceId, creationTime, size, location, storageClass, null, null, ImmutableMap.of(), 0L, 0L);
    }

    public GoogleCloudStorageItemInfo(StorageResourceId resourceId, long creationTime, long size, String location, String storageClass, String contentType, String contentEncoding, Map<String, byte[]> metadata, long contentGeneration, long metaGeneration) {
        this(resourceId, creationTime, size, location, storageClass, contentType, contentEncoding, metadata, contentGeneration, metaGeneration, new VerificationAttributes(null, null));
    }

    public GoogleCloudStorageItemInfo(StorageResourceId resourceId, long creationTime, long size, String location, String storageClass, String contentType, String contentEncoding, Map<String, byte[]> metadata, long contentGeneration, long metaGeneration, VerificationAttributes verificationAttributes) {
        Preconditions.checkArgument(resourceId != null, "resourceId must not be null! Use StorageResourceId.ROOT to represent GCS root.");
        this.resourceId = resourceId;
        this.creationTime = creationTime;
        this.size = size;
        this.location = location;
        this.storageClass = storageClass;
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
        this.metadata = metadata == null ? EMPTY_METADATA : metadata;
        this.contentGeneration = contentGeneration;
        this.metaGeneration = metaGeneration;
        this.verificationAttributes = verificationAttributes;
    }

    public String getBucketName() {
        return this.resourceId.getBucketName();
    }

    public String getObjectName() {
        return this.resourceId.getObjectName();
    }

    public StorageResourceId getResourceId() {
        return this.resourceId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getSize() {
        return this.size;
    }

    public String getLocation() {
        return this.location;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public Map<String, byte[]> getMetadata() {
        return this.metadata;
    }

    public boolean isBucket() {
        return this.resourceId.isBucket();
    }

    public boolean isRoot() {
        return this.resourceId.isRoot();
    }

    public boolean exists() {
        return this.size >= 0L;
    }

    public long getContentGeneration() {
        return this.contentGeneration;
    }

    public long getMetaGeneration() {
        return this.metaGeneration;
    }

    public VerificationAttributes getVerificationAttributes() {
        return this.verificationAttributes;
    }

    public boolean metadataEquals(Map<String, byte[]> otherMetadata) {
        if (this.metadata == otherMetadata) {
            return true;
        }
        if (this.metadata == null || otherMetadata == null) {
            return false;
        }
        if (!this.metadata.keySet().equals(otherMetadata.keySet())) {
            return false;
        }
        for (Map.Entry<String, byte[]> metadataEntry : this.metadata.entrySet()) {
            if (Arrays.equals(metadataEntry.getValue(), otherMetadata.get(metadataEntry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.exists()) {
            return String.format("%s: created on: %s", this.resourceId, new Date(this.creationTime));
        }
        return String.format("%s: exists: no", this.resourceId);
    }

    public boolean equals(Object obj) {
        if (obj instanceof GoogleCloudStorageItemInfo) {
            GoogleCloudStorageItemInfo other = (GoogleCloudStorageItemInfo)obj;
            return this.resourceId.equals(other.resourceId) && this.creationTime == other.creationTime && this.size == other.size && Objects.equals(this.location, other.location) && Objects.equals(this.storageClass, other.storageClass) && Objects.equals(this.verificationAttributes, other.verificationAttributes) && this.metaGeneration == other.metaGeneration && this.contentGeneration == other.contentGeneration && this.metadataEquals(other.getMetadata());
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.resourceId.hashCode();
        result = 31 * result + (int)this.creationTime;
        result = 31 * result + (int)this.size;
        result = 31 * result + Objects.hashCode(this.location);
        result = 31 * result + Objects.hashCode(this.storageClass);
        result = 31 * result + Objects.hashCode(this.verificationAttributes);
        result = 31 * result + (int)this.metaGeneration;
        result = 31 * result + (int)this.contentGeneration;
        result = 31 * result + this.metadata.hashCode();
        return result;
    }

    public static interface Provider {
        public GoogleCloudStorageItemInfo getItemInfo();
    }
}

