/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.AutoValue_GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;

@AutoValue
public abstract class GoogleCloudStorageReadOptions {
    public static final int DEFAULT_BACKOFF_INITIAL_INTERVAL_MILLIS = 200;
    public static final double DEFAULT_BACKOFF_RANDOMIZATION_FACTOR = 0.5;
    public static final double DEFAULT_BACKOFF_MULTIPLIER = 1.5;
    public static final int DEFAULT_BACKOFF_MAX_INTERVAL_MILLIS = 10000;
    public static final int DEFAULT_BACKOFF_MAX_ELAPSED_TIME_MILLIS = 120000;
    public static final boolean DEFAULT_FAST_FAIL_ON_NOT_FOUND = true;
    public static final int DEFAULT_BUFFER_SIZE = 0;
    public static final long DEFAULT_INPLACE_SEEK_LIMIT = 0L;
    public static final Fadvise DEFAULT_FADVISE = Fadvise.SEQUENTIAL;
    public static final int DEFAULT_MIN_RANGE_REQUEST_SIZE = 524288;
    public static final GenerationReadConsistency DEFAULT_GENERATION_READ_CONSISTENCY = GenerationReadConsistency.LATEST;
    public static final GoogleCloudStorageReadOptions DEFAULT = GoogleCloudStorageReadOptions.builder().build();

    public static Builder builder() {
        return new AutoValue_GoogleCloudStorageReadOptions.Builder().setBackoffInitialIntervalMillis(200).setBackoffRandomizationFactor(0.5).setBackoffMultiplier(1.5).setBackoffMaxIntervalMillis(10000).setBackoffMaxElapsedTimeMillis(120000).setFastFailOnNotFound(true).setBufferSize(0).setInplaceSeekLimit(0L).setFadvise(DEFAULT_FADVISE).setMinRangeRequestSize(524288).setGenerationReadConsistency(DEFAULT_GENERATION_READ_CONSISTENCY);
    }

    public abstract int getBackoffInitialIntervalMillis();

    public abstract double getBackoffRandomizationFactor();

    public abstract double getBackoffMultiplier();

    public abstract int getBackoffMaxIntervalMillis();

    public abstract int getBackoffMaxElapsedTimeMillis();

    public abstract boolean getFastFailOnNotFound();

    public abstract int getBufferSize();

    public abstract long getInplaceSeekLimit();

    public abstract Fadvise getFadvise();

    public abstract int getMinRangeRequestSize();

    public abstract GenerationReadConsistency getGenerationReadConsistency();

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setBackoffInitialIntervalMillis(int var1);

        public abstract Builder setBackoffRandomizationFactor(double var1);

        public abstract Builder setBackoffMultiplier(double var1);

        public abstract Builder setBackoffMaxIntervalMillis(int var1);

        public abstract Builder setBackoffMaxElapsedTimeMillis(int var1);

        public abstract Builder setFastFailOnNotFound(boolean var1);

        public abstract Builder setBufferSize(int var1);

        public abstract Builder setInplaceSeekLimit(long var1);

        public abstract Builder setFadvise(Fadvise var1);

        public abstract Builder setMinRangeRequestSize(int var1);

        public abstract Builder setGenerationReadConsistency(GenerationReadConsistency var1);

        abstract GoogleCloudStorageReadOptions autoBuild();

        public GoogleCloudStorageReadOptions build() {
            GoogleCloudStorageReadOptions options = this.autoBuild();
            Preconditions.checkState(options.getInplaceSeekLimit() >= 0L, "inplaceSeekLimit must be non-negative! Got %s", options.getInplaceSeekLimit());
            return options;
        }
    }

    public static enum GenerationReadConsistency {
        LATEST,
        BEST_EFFORT,
        STRICT;

    }

    public static enum Fadvise {
        AUTO,
        RANDOM,
        SEQUENTIAL;

    }
}

