/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.AutoValue_PerformanceCachingGoogleCloudStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;

@AutoValue
public abstract class PerformanceCachingGoogleCloudStorageOptions {
    public static final long MAX_ENTRY_AGE_MILLIS_DEFAULT = 5000L;
    public static final boolean LIST_CACHING_ENABLED = false;
    @Deprecated
    public static final long DIR_METADATA_PREFETCH_LIMIT_DEFAULT = 1000L;
    public static final PerformanceCachingGoogleCloudStorageOptions DEFAULT = PerformanceCachingGoogleCloudStorageOptions.builder().build();

    public static Builder builder() {
        return new AutoValue_PerformanceCachingGoogleCloudStorageOptions.Builder().setMaxEntryAgeMillis(5000L).setListCachingEnabled(false).setDirMetadataPrefetchLimit(1000L);
    }

    public abstract long getMaxEntryAgeMillis();

    public abstract boolean isListCachingEnabled();

    @Deprecated
    public abstract long getDirMetadataPrefetchLimit();

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setMaxEntryAgeMillis(long var1);

        public abstract Builder setListCachingEnabled(boolean var1);

        @Deprecated
        public abstract Builder setDirMetadataPrefetchLimit(long var1);

        abstract PerformanceCachingGoogleCloudStorageOptions autoBuild();

        public PerformanceCachingGoogleCloudStorageOptions build() {
            PerformanceCachingGoogleCloudStorageOptions options = this.autoBuild();
            Preconditions.checkState(options.getDirMetadataPrefetchLimit() >= -1L, "dirMetadataPrefetchLimit should be greater or equal to -1");
            return options;
        }
    }
}

