/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Optional;
import org.apache.hadoop.util.VersionInfo;

public class HadoopVersionInfo {
    private static final HadoopVersionInfo INSTANCE = new HadoopVersionInfo(VersionInfo.getVersion());
    private final Integer majorVersion;
    private final Integer minorVersion;
    private final Integer subminorVersion;

    public static HadoopVersionInfo getInstance() {
        return INSTANCE;
    }

    @VisibleForTesting
    HadoopVersionInfo(String versionString) {
        String[] versionPieces = versionString.split("[^0-9]+", 4);
        this.majorVersion = this.parseNumberPiece(versionPieces, 0);
        this.minorVersion = this.majorVersion == null ? null : this.parseNumberPiece(versionPieces, 1);
        this.subminorVersion = this.minorVersion == null ? null : this.parseNumberPiece(versionPieces, 2);
    }

    private Integer parseNumberPiece(String[] pieces, int index) {
        if (index >= pieces.length || pieces[index].isEmpty()) {
            return null;
        }
        try {
            return Integer.parseInt(pieces[index], 10);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse version piece as a number: " + pieces[index], e);
        }
    }

    public Optional<Integer> getMajorVersion() {
        return Optional.fromNullable(this.majorVersion);
    }

    public Optional<Integer> getMinorVersion() {
        return Optional.fromNullable(this.minorVersion);
    }

    public Optional<Integer> getSubminorVersion() {
        return Optional.fromNullable(this.subminorVersion);
    }

    public boolean isGreaterThan(int major, int minor) {
        return this.majorVersion != null && this.majorVersion > major || this.majorVersion != null && this.majorVersion == major && this.minorVersion != null && this.minorVersion > minor;
    }

    public boolean isLessThan(int major, int minor) {
        return this.majorVersion != null && this.majorVersion < major || this.majorVersion != null && this.majorVersion == major && this.minorVersion != null && this.minorVersion < minor;
    }

    public boolean isEqualTo(int major, int minor) {
        return this.majorVersion != null && this.majorVersion == major && this.minorVersion != null && this.minorVersion == minor;
    }
}

