/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.log4j;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.LogData;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.LoggerBackend;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.log4j.SimpleLogEvent;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

final class Log4jLoggerBackend
extends LoggerBackend {
    private final Logger logger;

    static Level toLog4jLevel(java.util.logging.Level level) {
        if (level.intValue() >= java.util.logging.Level.SEVERE.intValue()) {
            return Level.ERROR;
        }
        if (level.intValue() >= java.util.logging.Level.WARNING.intValue()) {
            return Level.WARN;
        }
        if (level.intValue() >= java.util.logging.Level.INFO.intValue()) {
            return Level.INFO;
        }
        if (level.intValue() >= java.util.logging.Level.FINE.intValue()) {
            return Level.DEBUG;
        }
        return Level.TRACE;
    }

    Log4jLoggerBackend(Logger logger) {
        this.logger = logger;
    }

    @Override
    public String getLoggerName() {
        return this.logger.getName();
    }

    @Override
    public boolean isLoggable(java.util.logging.Level level) {
        return this.logger.isEnabledFor((Priority)Log4jLoggerBackend.toLog4jLevel(level));
    }

    private void log(SimpleLogEvent logEntry, boolean wasForced) {
        if (wasForced || this.logger.isEnabledFor((Priority)logEntry.getLevel())) {
            this.forceLog(this.logger, logEntry);
        }
    }

    @Override
    public void log(LogData logData) {
        this.log(SimpleLogEvent.create(this.logger, logData), logData.wasForced());
    }

    @Override
    public void handleError(RuntimeException error, LogData badData) {
        this.log(SimpleLogEvent.error(this.logger, error, badData), badData.wasForced());
    }

    private void forceLog(Logger logger, SimpleLogEvent logEntry) {
        logger.callAppenders(logEntry.asLoggingEvent());
    }
}

