/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StringPaths;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.UriPaths;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class FileInfo {
    public static final FileInfo ROOT_INFO = new FileInfo(GoogleCloudStorageFileSystem.GCS_ROOT, GoogleCloudStorageItemInfo.ROOT_INFO);
    private final URI path;
    private final GoogleCloudStorageItemInfo itemInfo;
    private final Map<String, byte[]> attributes;

    private FileInfo(URI path, GoogleCloudStorageItemInfo itemInfo) {
        this.itemInfo = itemInfo;
        this.path = path;
        Preconditions.checkArgument(itemInfo.getMetadata() != null);
        this.attributes = itemInfo.getMetadata();
    }

    public URI getPath() {
        return this.path;
    }

    public boolean isDirectory() {
        return this.itemInfo.isDirectory();
    }

    public boolean isGlobalRoot() {
        return this.itemInfo.isGlobalRoot();
    }

    public long getCreationTime() {
        return this.itemInfo.getCreationTime();
    }

    public long getSize() {
        return this.itemInfo.getSize();
    }

    public long getModificationTime() {
        return this.itemInfo.getModificationTime();
    }

    public Map<String, byte[]> getAttributes() {
        return this.attributes;
    }

    public boolean exists() {
        return this.itemInfo.exists();
    }

    public String toString() {
        return this.getPath() + (this.exists() ? ": created on: " + new Date(this.getCreationTime()) : ": exists: no");
    }

    public GoogleCloudStorageItemInfo getItemInfo() {
        return this.itemInfo;
    }

    public static StorageResourceId convertToDirectoryPath(StorageResourceId resourceId) {
        if (resourceId.isStorageObject() && !StringPaths.isDirectoryPath(resourceId.getObjectName())) {
            resourceId = new StorageResourceId(resourceId.getBucketName(), StringPaths.toDirectoryPath(resourceId.getObjectName()));
        }
        return resourceId;
    }

    public static URI convertToDirectoryPath(URI path) {
        StorageResourceId resourceId = StorageResourceId.fromUriPath(path, true);
        if (resourceId.isStorageObject() && !StringPaths.isDirectoryPath(resourceId.getObjectName())) {
            resourceId = FileInfo.convertToDirectoryPath(resourceId);
            path = UriPaths.fromResourceId(resourceId, false);
        }
        return path;
    }

    public static FileInfo fromItemInfo(GoogleCloudStorageItemInfo itemInfo) {
        if (itemInfo.isRoot()) {
            return ROOT_INFO;
        }
        URI path = UriPaths.fromResourceId(itemInfo.getResourceId(), true);
        return new FileInfo(path, itemInfo);
    }

    public static List<FileInfo> fromItemInfos(List<GoogleCloudStorageItemInfo> itemInfos) {
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>(itemInfos.size());
        for (GoogleCloudStorageItemInfo itemInfo : itemInfos) {
            fileInfos.add(FileInfo.fromItemInfo(itemInfo));
        }
        return fileInfos;
    }

    public static boolean isDirectoryPath(URI path) {
        return path != null && path.toString().endsWith("/");
    }
}

