/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.testing;

public abstract class TestConfiguration {
    public static final String GCS_TEST_PROJECT_ID = "GCS_TEST_PROJECT_ID";
    public static final String GCS_TEST_SERVICE_ACCOUNT = "GCS_TEST_SERVICE_ACCOUNT";
    public static final String GCS_TEST_PRIVATE_KEYFILE = "GCS_TEST_PRIVATE_KEYFILE";

    public static TestConfiguration getInstance() {
        return LazyHolder.INSTANCE;
    }

    public abstract String getProjectId();

    public abstract String getServiceAccount();

    public abstract String getPrivateKeyFile();

    private static class LazyHolder {
        private static final TestConfiguration INSTANCE = new EnvironmentBasedTestConfiguration();

        private LazyHolder() {
        }
    }

    public static class EnvironmentBasedTestConfiguration
    extends TestConfiguration {
        @Override
        public String getProjectId() {
            return System.getenv(TestConfiguration.GCS_TEST_PROJECT_ID);
        }

        @Override
        public String getServiceAccount() {
            return System.getenv(TestConfiguration.GCS_TEST_SERVICE_ACCOUNT);
        }

        @Override
        public String getPrivateKeyFile() {
            return System.getenv(TestConfiguration.GCS_TEST_PRIVATE_KEYFILE);
        }
    }
}

