/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.HadoopConfigurationProperty;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Joiner;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;

public class ConfigurationUtil {
    public static <T extends HadoopConfigurationProperty<?>> String getMandatoryConfig(Configuration config, T property) throws IOException {
        String value = config.get(property.getKey());
        if (Strings.isNullOrEmpty(value)) {
            throw new IOException("Must supply a value for configuration setting: " + property.getKey());
        }
        return value;
    }

    public static <T extends HadoopConfigurationProperty<?>> Map<String, String> getMandatoryConfig(Configuration config, List<T> properties) throws IOException {
        ArrayList<String> missingKeys = new ArrayList<String>();
        HashMap<String, String> values = new HashMap<String, String>();
        for (HadoopConfigurationProperty property : properties) {
            String value = config.get(property.getKey());
            if (Strings.isNullOrEmpty(value)) {
                missingKeys.add(property.getKey());
                continue;
            }
            values.put(property.getKey(), value);
        }
        if (missingKeys.size() > 0) {
            Joiner joiner = Joiner.on(", ");
            String message = "Must supply value for configuration settings: " + joiner.join(missingKeys);
            throw new IOException(message);
        }
        return values;
    }
}

