/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.auth.oauth2.TokenResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpTransport;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.JsonFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.jackson2.JacksonFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.Clock;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.iamcredentials.v1.IAMCredentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.iamcredentials.v1.model.GenerateAccessTokenRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.iamcredentials.v1.model.GenerateAccessTokenResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Strings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.time.Instant;

public class GoogleCredentialWithIamAccessToken
extends GoogleCredential {
    private static final JsonFactory JSON_FACTORY = new JacksonFactory();
    private static final String DEFAULT_ACCESS_TOKEN_LIFETIME = "3600s";
    private static final String DEFAULT_SERVICE_ACCOUNT_NAME_PREFIX = "projects/-/serviceAccounts/";
    private final HttpRequestInitializer initializer;
    private final HttpTransport transport;
    private final String serviceAccountResource;
    private final ImmutableList<String> scopes;
    private final Clock clock;

    public GoogleCredentialWithIamAccessToken(HttpTransport transport, HttpRequestInitializer initializer, String serviceAccountName, ImmutableList<String> scopes) throws IOException {
        this(transport, initializer, serviceAccountName, scopes, Clock.SYSTEM);
    }

    @VisibleForTesting
    public GoogleCredentialWithIamAccessToken(HttpTransport transport, HttpRequestInitializer initializer, String serviceAccountName, ImmutableList<String> scopes, Clock clock) throws IOException {
        this.serviceAccountResource = DEFAULT_SERVICE_ACCOUNT_NAME_PREFIX + serviceAccountName;
        this.initializer = initializer;
        this.transport = transport;
        this.scopes = scopes;
        this.clock = clock;
        this.initialize();
    }

    private void initialize() throws IOException {
        GenerateAccessTokenResponse accessTokenResponse = this.generateAccessToken();
        if (!Strings.isNullOrEmpty(accessTokenResponse.getExpireTime())) {
            Instant expireTimeInstant = Instant.parse(accessTokenResponse.getExpireTime());
            this.setExpirationTimeMilliseconds(expireTimeInstant.toEpochMilli());
        }
        this.setAccessToken(accessTokenResponse.getAccessToken());
    }

    @Override
    protected TokenResponse executeRefreshToken() throws IOException {
        GenerateAccessTokenResponse accessTokenResponse = this.generateAccessToken();
        TokenResponse tokenResponse = new TokenResponse().setAccessToken(accessTokenResponse.getAccessToken());
        if (Strings.isNullOrEmpty(accessTokenResponse.getExpireTime())) {
            return tokenResponse;
        }
        Instant expirationTimeInInstant = Instant.parse(accessTokenResponse.getExpireTime());
        long expirationTimeMilliSeconds = expirationTimeInInstant.getEpochSecond();
        return tokenResponse.setExpiresInSeconds(expirationTimeMilliSeconds - this.clock.currentTimeMillis() / 1000L);
    }

    private GenerateAccessTokenResponse generateAccessToken() throws IOException {
        GenerateAccessTokenRequest requestContent = new GenerateAccessTokenRequest().setScope(this.scopes).setLifetime(DEFAULT_ACCESS_TOKEN_LIFETIME);
        IAMCredentials.Projects.ServiceAccounts.GenerateAccessToken request = new IAMCredentials(this.transport, JSON_FACTORY, this.initializer).projects().serviceAccounts().generateAccessToken(this.serviceAccountResource, requestContent);
        GenerateAccessTokenResponse response = (GenerateAccessTokenResponse)request.execute();
        Preconditions.checkNotNull(response.getAccessToken(), "Access Token cannot be null!");
        return response;
    }
}

