/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.KeyValueFormatter;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.KeyValueHandler;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.util.Checks;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Tags {
    private static final Comparator<Object> VALUE_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object lhs, Object rhs) {
            Type rtype;
            Type type = Type.of(lhs);
            return type == (rtype = Type.of(rhs)) ? type.compare(lhs, rhs) : type.compareTo(rtype);
        }
    };
    private static final SortedSet<Object> EMPTY_SET = Collections.unmodifiableSortedSet(new TreeSet());
    private static final Tags EMPTY_TAGS = new Tags(Collections.unmodifiableSortedMap(new TreeMap()));
    private final SortedMap<String, SortedSet<Object>> map;
    private Integer hashCode = null;
    private String toString = null;

    public static Builder builder() {
        return new Builder();
    }

    public static Tags empty() {
        return EMPTY_TAGS;
    }

    public static Tags of(String name, String value) {
        return Tags.builder().addTag(name, value).build();
    }

    public static Tags of(String name, boolean value) {
        return Tags.builder().addTag(name, value).build();
    }

    public static Tags of(String name, long value) {
        return Tags.builder().addTag(name, value).build();
    }

    public static Tags of(String name, double value) {
        return Tags.builder().addTag(name, value).build();
    }

    private Tags(SortedMap<String, SortedSet<Object>> map) {
        this.map = map;
    }

    public SortedMap<String, SortedSet<Object>> asMap() {
        return this.map;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Tags merge(Tags other) {
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        TreeMap<String, SortedSet<Object>> merged = new TreeMap<String, SortedSet<Object>>();
        for (Map.Entry<String, SortedSet<Object>> e : this.map.entrySet()) {
            SortedSet otherValues = (SortedSet)other.map.get(e.getKey());
            if (otherValues == null || e.getValue().containsAll(otherValues)) {
                merged.put(e.getKey(), e.getValue());
                continue;
            }
            if (otherValues.containsAll((Collection)e.getValue())) {
                merged.put(e.getKey(), otherValues);
                continue;
            }
            TreeSet<Object> mergedValues = new TreeSet<Object>(e.getValue());
            mergedValues.addAll(otherValues);
            merged.put(e.getKey(), Collections.unmodifiableSortedSet(mergedValues));
        }
        for (Map.Entry<String, SortedSet<Object>> e : other.map.entrySet()) {
            if (this.map.containsKey(e.getKey())) continue;
            merged.put(e.getKey(), e.getValue());
        }
        return new Tags(Collections.unmodifiableSortedMap(merged));
    }

    public void emitAll(KeyValueHandler out) {
        for (Map.Entry<String, SortedSet<Object>> e : this.map.entrySet()) {
            String key = e.getKey();
            Set values = e.getValue();
            if (!values.isEmpty()) {
                for (Object value : values) {
                    out.handle(key, value);
                }
                continue;
            }
            out.handle(key, null);
        }
    }

    public boolean equals(@NullableDecl Object obj) {
        return obj instanceof Tags && ((Tags)obj).map.equals(this.map);
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.map.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.toString == null) {
            StringBuilder out = new StringBuilder();
            KeyValueFormatter formatter = new KeyValueFormatter("[ ", " ]", out);
            this.emitAll(formatter);
            formatter.done();
            this.toString = out.toString();
        }
        return this.toString;
    }

    public static final class Builder {
        private final SortedMap<String, SortedSet<Object>> map = new TreeMap<String, SortedSet<Object>>();

        @CanIgnoreReturnValue
        public Builder addTag(String name) {
            Set values = (Set)this.map.get(Checks.checkMetadataIdentifier(name));
            if (values == null) {
                this.map.put(name, EMPTY_SET);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addTag(String name, String value) {
            if (value == null) {
                throw new IllegalArgumentException("tag values cannot be null");
            }
            this.addImpl(name, value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addTag(String name, boolean value) {
            this.addImpl(name, value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addTag(String name, long value) {
            this.addImpl(name, value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addTag(String name, double value) {
            this.addImpl(name, value);
            return this;
        }

        private void addImpl(String name, Object value) {
            TreeSet<Object> values = (TreeSet<Object>)this.map.get(Checks.checkMetadataIdentifier(name));
            if (values == null || values == EMPTY_SET) {
                values = new TreeSet<Object>(VALUE_COMPARATOR);
                this.map.put(name, values);
            }
            values.add(value);
        }

        public Tags build() {
            if (this.map.isEmpty()) {
                return EMPTY_TAGS;
            }
            TreeMap<String, SortedSet<Object>> copy = new TreeMap<String, SortedSet<Object>>();
            for (Map.Entry<String, SortedSet<Object>> e : this.map.entrySet()) {
                copy.put(e.getKey(), Collections.unmodifiableSortedSet(new TreeSet<Object>(e.getValue())));
            }
            return new Tags(Collections.unmodifiableSortedMap(copy));
        }

        public String toString() {
            return this.build().toString();
        }
    }

    private static enum Type {
        BOOLEAN{

            @Override
            int compare(Object lhs, Object rhs) {
                return ((Boolean)lhs).compareTo((Boolean)rhs);
            }
        }
        ,
        STRING{

            @Override
            int compare(Object lhs, Object rhs) {
                return ((String)lhs).compareTo((String)rhs);
            }
        }
        ,
        LONG{

            @Override
            int compare(Object lhs, Object rhs) {
                return ((Long)lhs).compareTo((Long)rhs);
            }
        }
        ,
        DOUBLE{

            @Override
            int compare(Object lhs, Object rhs) {
                return ((Double)lhs).compareTo((Double)rhs);
            }
        };


        abstract int compare(Object var1, Object var2);

        private static Type of(Object tag) {
            if (tag instanceof String) {
                return STRING;
            }
            if (tag instanceof Boolean) {
                return BOOLEAN;
            }
            if (tag instanceof Long) {
                return LONG;
            }
            if (tag instanceof Double) {
                return DOUBLE;
            }
            throw new AssertionError((Object)("invalid tag type: " + tag.getClass()));
        }
    }
}

