/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.util;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.util.Checks;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.util.FastStackGetter;
import com.google.errorprone.annotations.CheckReturnValue;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@CheckReturnValue
public final class CallerFinder {
    private static final FastStackGetter stackGetter = FastStackGetter.createIfSupported();

    @NullableDecl
    public static StackTraceElement findCallerOf(Class<?> target, Throwable throwable, int skip) {
        Checks.checkNotNull(target, "target");
        Checks.checkNotNull(throwable, "throwable");
        if (skip < 0) {
            throw new IllegalArgumentException("skip count cannot be negative: " + skip);
        }
        StackTraceElement[] stack = stackGetter != null ? null : throwable.getStackTrace();
        boolean foundCaller = false;
        try {
            int index = skip;
            while (true) {
                StackTraceElement element;
                StackTraceElement stackTraceElement = element = stackGetter != null ? stackGetter.getStackTraceElement(throwable, index) : stack[index];
                if (target.getName().equals(element.getClassName())) {
                    foundCaller = true;
                } else if (foundCaller) {
                    return element;
                }
                ++index;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public static StackTraceElement[] getStackForCallerOf(Class<?> target, Throwable throwable, int maxDepth) {
        int depth;
        StackTraceElement[] stack;
        Checks.checkNotNull(target, "target");
        Checks.checkNotNull(throwable, "throwable");
        if (maxDepth <= 0 && maxDepth != -1) {
            throw new IllegalArgumentException("invalid maximum depth: " + maxDepth);
        }
        if (stackGetter != null) {
            stack = null;
            depth = stackGetter.getStackTraceDepth(throwable);
        } else {
            stack = throwable.getStackTrace();
            depth = stack.length;
        }
        boolean foundCaller = false;
        for (int index = 0; index < depth; ++index) {
            StackTraceElement element;
            StackTraceElement stackTraceElement = element = stackGetter != null ? stackGetter.getStackTraceElement(throwable, index) : stack[index];
            if (target.getName().equals(element.getClassName())) {
                foundCaller = true;
                continue;
            }
            if (!foundCaller) continue;
            int elementsToAdd = depth - index;
            if (maxDepth > 0 && maxDepth < elementsToAdd) {
                elementsToAdd = maxDepth;
            }
            StackTraceElement[] syntheticStack = new StackTraceElement[elementsToAdd];
            syntheticStack[0] = element;
            for (int n = 1; n < elementsToAdd; ++n) {
                syntheticStack[n] = stackGetter != null ? stackGetter.getStackTraceElement(throwable, index + n) : stack[index + n];
            }
            return syntheticStack;
        }
        return new StackTraceElement[0];
    }
}

