/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts;

import com.google.cloud.hadoop.repackaged.gcs.io.grpc.BindableService;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Channel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.CompressorRegistry;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.DecompressorRegistry;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ExperimentalApi;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.HandlerRegistry;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Metadata;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Server;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ServerBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ServerCall;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ServerCallHandler;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ServerInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ServerServiceDefinition;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ServerStreamTracer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ServerTransportFilter;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.CheckGcpEnvironment;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.HandshakerServiceChannel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.AltsProtocolNegotiator;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.ObjectPool;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.SharedResourcePool;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4151")
public final class AltsServerBuilder
extends ServerBuilder<AltsServerBuilder> {
    private static final Logger logger = Logger.getLogger(AltsServerBuilder.class.getName());
    private final NettyServerBuilder delegate;
    private ObjectPool<Channel> handshakerChannelPool = SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL);
    private boolean enableUntrustedAlts;

    private AltsServerBuilder(NettyServerBuilder nettyDelegate) {
        this.delegate = nettyDelegate;
    }

    public static AltsServerBuilder forPort(int port) {
        NettyServerBuilder nettyDelegate = NettyServerBuilder.forAddress(new InetSocketAddress(port));
        return new AltsServerBuilder(nettyDelegate);
    }

    public AltsServerBuilder enableUntrustedAltsForTesting() {
        this.enableUntrustedAlts = true;
        return this;
    }

    public AltsServerBuilder setHandshakerAddressForTesting(String handshakerAddress) {
        this.handshakerChannelPool = SharedResourcePool.forResource(HandshakerServiceChannel.getHandshakerChannelForTesting(handshakerAddress));
        return this;
    }

    @Override
    public AltsServerBuilder handshakeTimeout(long timeout, TimeUnit unit) {
        this.delegate.handshakeTimeout(timeout, unit);
        return this;
    }

    @Override
    public AltsServerBuilder directExecutor() {
        this.delegate.directExecutor();
        return this;
    }

    @Override
    public AltsServerBuilder addStreamTracerFactory(ServerStreamTracer.Factory factory) {
        this.delegate.addStreamTracerFactory(factory);
        return this;
    }

    @Override
    public AltsServerBuilder addTransportFilter(ServerTransportFilter filter) {
        this.delegate.addTransportFilter(filter);
        return this;
    }

    @Override
    public AltsServerBuilder executor(Executor executor) {
        this.delegate.executor(executor);
        return this;
    }

    @Override
    public AltsServerBuilder addService(ServerServiceDefinition service) {
        this.delegate.addService(service);
        return this;
    }

    @Override
    public AltsServerBuilder addService(BindableService bindableService) {
        this.delegate.addService(bindableService);
        return this;
    }

    @Override
    public AltsServerBuilder fallbackHandlerRegistry(HandlerRegistry fallbackRegistry) {
        this.delegate.fallbackHandlerRegistry(fallbackRegistry);
        return this;
    }

    @Override
    public AltsServerBuilder useTransportSecurity(File certChain, File privateKey) {
        throw new UnsupportedOperationException("Can't set TLS settings for ALTS");
    }

    @Override
    public AltsServerBuilder decompressorRegistry(DecompressorRegistry registry) {
        this.delegate.decompressorRegistry(registry);
        return this;
    }

    @Override
    public AltsServerBuilder compressorRegistry(CompressorRegistry registry) {
        this.delegate.compressorRegistry(registry);
        return this;
    }

    @Override
    public AltsServerBuilder intercept(ServerInterceptor interceptor) {
        this.delegate.intercept(interceptor);
        return this;
    }

    @Override
    public Server build() {
        if (!CheckGcpEnvironment.isOnGcp()) {
            if (this.enableUntrustedAlts) {
                logger.log(Level.WARNING, "Untrusted ALTS mode is enabled and we cannot guarantee the trustworthiness of the ALTS handshaker service");
            } else {
                Status status = Status.INTERNAL.withDescription("ALTS is only allowed to run on Google Cloud Platform");
                this.delegate.intercept(new FailingServerInterceptor(status));
            }
        }
        this.delegate.protocolNegotiator(AltsProtocolNegotiator.serverAltsProtocolNegotiator(this.handshakerChannelPool));
        return this.delegate.build();
    }

    static final class FailingServerInterceptor
    implements ServerInterceptor {
        private final Status status;

        public FailingServerInterceptor(Status status) {
            this.status = status;
        }

        @Override
        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> nextHandler) {
            serverCall.close(this.status, new Metadata());
            return new ServerCall.Listener<ReqT>(){};
        }
    }
}

