/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.json.JsonHttpContent;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.Storage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.StorageRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.Bucket;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.ComposeRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.AccessBoundary;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Strings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.List;

class StorageRequestToAccessBoundaryConverter {
    StorageRequestToAccessBoundaryConverter() {
    }

    public static <RequestT extends StorageRequest<?>> List<AccessBoundary> fromStorageObjectRequest(RequestT request) {
        if (request instanceof Storage.Objects.List) {
            return StorageRequestToAccessBoundaryConverter.translateObjectListRequest((Storage.Objects.List)request);
        }
        if (request instanceof Storage.Objects.Insert) {
            return StorageRequestToAccessBoundaryConverter.translateObjectInsertRequest((Storage.Objects.Insert)request);
        }
        if (request instanceof Storage.Objects.Compose) {
            return StorageRequestToAccessBoundaryConverter.translateObjectComposeRequest((Storage.Objects.Compose)request);
        }
        if (request instanceof Storage.Objects.Get) {
            return StorageRequestToAccessBoundaryConverter.translateObjectGetRequest((Storage.Objects.Get)request);
        }
        if (request instanceof Storage.Objects.Delete) {
            return StorageRequestToAccessBoundaryConverter.translateObjectDeleteRequest((Storage.Objects.Delete)request);
        }
        if (request instanceof Storage.Objects.Rewrite) {
            return StorageRequestToAccessBoundaryConverter.translateObjectRewriteRequest((Storage.Objects.Rewrite)request);
        }
        if (request instanceof Storage.Objects.Copy) {
            return StorageRequestToAccessBoundaryConverter.translateObjectCopyRequest((Storage.Objects.Copy)request);
        }
        if (request instanceof Storage.Objects.Patch) {
            return StorageRequestToAccessBoundaryConverter.translateObjectPatchRequest((Storage.Objects.Patch)request);
        }
        if (request instanceof Storage.Buckets.Get) {
            return StorageRequestToAccessBoundaryConverter.translateBucketGetRequest((Storage.Buckets.Get)request);
        }
        if (request instanceof Storage.Buckets.Insert) {
            return StorageRequestToAccessBoundaryConverter.translateBucketInsertRequest((Storage.Buckets.Insert)request);
        }
        if (request instanceof Storage.Buckets.Delete) {
            return StorageRequestToAccessBoundaryConverter.translateBucketDeleteRequest((Storage.Buckets.Delete)request);
        }
        if (request instanceof Storage.Buckets.List) {
            return StorageRequestToAccessBoundaryConverter.translateBucketListRequest((Storage.Buckets.List)request);
        }
        throw new InvalidParameterException("StorageRequest not used by the connector: " + request.getClass().getCanonicalName());
    }

    private static List<AccessBoundary> translateObjectListRequest(Storage.Objects.List request) {
        String prefix = request.getPrefix();
        if (Strings.isNullOrEmpty(prefix)) {
            prefix = "/";
        }
        return Collections.singletonList(AccessBoundary.create(request.getBucket(), prefix, "read"));
    }

    private static List<AccessBoundary> translateObjectInsertRequest(Storage.Objects.Insert request) {
        String path = ((StorageObject)StorageRequestToAccessBoundaryConverter.getData(request)).getName();
        return Collections.singletonList(AccessBoundary.create(request.getBucket(), path, "write"));
    }

    private static List<AccessBoundary> translateObjectComposeRequest(Storage.Objects.Compose request) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        ((ComposeRequest)StorageRequestToAccessBoundaryConverter.getData(request)).getSourceObjects().forEach(source -> listBuilder.add(AccessBoundary.create(request.getDestinationBucket(), source.getName(), "read")));
        listBuilder.add(AccessBoundary.create(request.getDestinationBucket(), request.getDestinationObject(), "write"));
        return listBuilder.build();
    }

    private static List<AccessBoundary> translateObjectGetRequest(Storage.Objects.Get request) {
        return Collections.singletonList(AccessBoundary.create(request.getBucket(), request.getObject(), "read"));
    }

    private static List<AccessBoundary> translateObjectDeleteRequest(Storage.Objects.Delete request) {
        return Collections.singletonList(AccessBoundary.create(request.getBucket(), request.getObject(), "write"));
    }

    private static List<AccessBoundary> translateObjectRewriteRequest(Storage.Objects.Rewrite request) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        listBuilder.add(AccessBoundary.create(request.getSourceBucket(), request.getSourceObject(), "read"));
        listBuilder.add(AccessBoundary.create(request.getDestinationBucket(), request.getDestinationObject(), "write"));
        return listBuilder.build();
    }

    private static List<AccessBoundary> translateObjectCopyRequest(Storage.Objects.Copy request) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        listBuilder.add(AccessBoundary.create(request.getSourceBucket(), request.getSourceObject(), "read"));
        listBuilder.add(AccessBoundary.create(request.getDestinationBucket(), request.getDestinationObject(), "write"));
        return listBuilder.build();
    }

    private static List<AccessBoundary> translateObjectPatchRequest(Storage.Objects.Patch request) {
        return Collections.singletonList(AccessBoundary.create(request.getBucket(), request.getObject(), "write"));
    }

    private static List<AccessBoundary> translateBucketGetRequest(Storage.Buckets.Get request) {
        return Collections.singletonList(AccessBoundary.create(request.getBucket(), "/", "read"));
    }

    private static List<AccessBoundary> translateBucketInsertRequest(Storage.Buckets.Insert request) {
        String bucketName = ((Bucket)StorageRequestToAccessBoundaryConverter.getData(request)).getName();
        return Collections.singletonList(AccessBoundary.create(bucketName, "/", "write"));
    }

    private static List<AccessBoundary> translateBucketDeleteRequest(Storage.Buckets.Delete request) {
        return Collections.singletonList(AccessBoundary.create(request.getBucket(), "/", "write"));
    }

    private static List<AccessBoundary> translateBucketListRequest(Storage.Buckets.List request) {
        return Collections.singletonList(AccessBoundary.create("", "", "read"));
    }

    private static Object getData(StorageRequest<?> request) {
        return ((JsonHttpContent)request.getHttpContent()).getData();
    }
}

