/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RetryHttpInitializerOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Nullable;

final class AutoValue_RetryHttpInitializerOptions
extends RetryHttpInitializerOptions {
    private final String defaultUserAgent;
    private final ImmutableMap<String, String> httpHeaders;
    private final Duration connectTimeout;
    private final Duration readTimeout;
    private final int maxRequestRetries;

    private AutoValue_RetryHttpInitializerOptions(@Nullable String defaultUserAgent, ImmutableMap<String, String> httpHeaders, Duration connectTimeout, Duration readTimeout, int maxRequestRetries) {
        this.defaultUserAgent = defaultUserAgent;
        this.httpHeaders = httpHeaders;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.maxRequestRetries = maxRequestRetries;
    }

    @Override
    @Nullable
    public String getDefaultUserAgent() {
        return this.defaultUserAgent;
    }

    @Override
    public ImmutableMap<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    @Override
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public int getMaxRequestRetries() {
        return this.maxRequestRetries;
    }

    public String toString() {
        return "RetryHttpInitializerOptions{defaultUserAgent=" + this.defaultUserAgent + ", httpHeaders=" + this.httpHeaders + ", connectTimeout=" + this.connectTimeout + ", readTimeout=" + this.readTimeout + ", maxRequestRetries=" + this.maxRequestRetries + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RetryHttpInitializerOptions) {
            RetryHttpInitializerOptions that = (RetryHttpInitializerOptions)o;
            return (this.defaultUserAgent == null ? that.getDefaultUserAgent() == null : this.defaultUserAgent.equals(that.getDefaultUserAgent())) && this.httpHeaders.equals(that.getHttpHeaders()) && this.connectTimeout.equals(that.getConnectTimeout()) && this.readTimeout.equals(that.getReadTimeout()) && this.maxRequestRetries == that.getMaxRequestRetries();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.defaultUserAgent == null ? 0 : this.defaultUserAgent.hashCode();
        h$ *= 1000003;
        h$ ^= this.httpHeaders.hashCode();
        h$ *= 1000003;
        h$ ^= this.connectTimeout.hashCode();
        h$ *= 1000003;
        h$ ^= this.readTimeout.hashCode();
        h$ *= 1000003;
        return h$ ^= this.maxRequestRetries;
    }

    @Override
    public RetryHttpInitializerOptions.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends RetryHttpInitializerOptions.Builder {
        private String defaultUserAgent;
        private ImmutableMap<String, String> httpHeaders;
        private Duration connectTimeout;
        private Duration readTimeout;
        private Integer maxRequestRetries;

        Builder() {
        }

        private Builder(RetryHttpInitializerOptions source) {
            this.defaultUserAgent = source.getDefaultUserAgent();
            this.httpHeaders = source.getHttpHeaders();
            this.connectTimeout = source.getConnectTimeout();
            this.readTimeout = source.getReadTimeout();
            this.maxRequestRetries = source.getMaxRequestRetries();
        }

        @Override
        public RetryHttpInitializerOptions.Builder setDefaultUserAgent(String defaultUserAgent) {
            this.defaultUserAgent = defaultUserAgent;
            return this;
        }

        @Override
        public RetryHttpInitializerOptions.Builder setHttpHeaders(Map<String, String> httpHeaders) {
            this.httpHeaders = ImmutableMap.copyOf(httpHeaders);
            return this;
        }

        @Override
        public RetryHttpInitializerOptions.Builder setConnectTimeout(Duration connectTimeout) {
            if (connectTimeout == null) {
                throw new NullPointerException("Null connectTimeout");
            }
            this.connectTimeout = connectTimeout;
            return this;
        }

        @Override
        public RetryHttpInitializerOptions.Builder setReadTimeout(Duration readTimeout) {
            if (readTimeout == null) {
                throw new NullPointerException("Null readTimeout");
            }
            this.readTimeout = readTimeout;
            return this;
        }

        @Override
        public RetryHttpInitializerOptions.Builder setMaxRequestRetries(int maxRequestRetries) {
            this.maxRequestRetries = maxRequestRetries;
            return this;
        }

        @Override
        public RetryHttpInitializerOptions build() {
            String missing = "";
            if (this.httpHeaders == null) {
                missing = missing + " httpHeaders";
            }
            if (this.connectTimeout == null) {
                missing = missing + " connectTimeout";
            }
            if (this.readTimeout == null) {
                missing = missing + " readTimeout";
            }
            if (this.maxRequestRetries == null) {
                missing = missing + " maxRequestRetries";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_RetryHttpInitializerOptions(this.defaultUserAgent, this.httpHeaders, this.connectTimeout, this.readTimeout, this.maxRequestRetries);
        }
    }
}

